/*-*- C++ -*-*/
//#############################################################################
//## File: IDLtoC/be_generic/be_generator.cc
//## Author: Jeremy Heiner
//## Organization: Georgia Institute of Technology
//## Copyright: see below
//## Purpose: generic template files for BE classes
//#############################################################################
//## History: the front end was developed by SunSoft, see their copyright
//## message below.  Dilma Silva, also here at gatech, developed the code
//## into an idl2c compiler to support the COBS project.  i'm starting with
//## dilma's code.

/*

COPYRIGHT

Copyright 1992, 1993, 1994 Sun Microsystems, Inc.  Printed in the United
States of America.  All Rights Reserved.

This product is protected by copyright and distributed under the following
license restricting its use.

The Interface Definition Language Compiler Front End (CFE) is made
available for your use provided that you include this license and copyright
notice on all media and documentation and the software program in which
this product is incorporated in whole or part. You may copy and extend
functionality (but may not remove functionality) of the Interface
Definition Language CFE without charge, but you are not authorized to
license or distribute it to anyone else except as part of a product or
program developed by you or with the express written consent of Sun
Microsystems, Inc. ("Sun").

The names of Sun Microsystems, Inc. and any of its subsidiaries or
affiliates may not be used in advertising or publicity pertaining to
distribution of Interface Definition Language CFE as permitted herein.

This license is effective until terminated by Sun for failure to comply
with this license.  Upon termination, you shall destroy or return all code
and documentation for the Interface Definition Language CFE.

INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES OF
ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS
FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A COURSE OF
DEALING, USAGE OR TRADE PRACTICE.

INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED WITH NO SUPPORT AND WITHOUT
ANY OBLIGATION ON THE PART OF Sun OR ANY OF ITS SUBSIDIARIES OR AFFILIATES
TO ASSIST IN ITS USE, CORRECTION, MODIFICATION OR ENHANCEMENT.

SUN OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL HAVE NO LIABILITY WITH
RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
INTERFACE DEFINITION LANGUAGE CFE OR ANY PART THEREOF.

IN NO EVENT WILL SUN OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE FOR
ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL
DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

Use, duplication, or disclosure by the government is subject to
restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in
Technical Data and Computer Software clause at DFARS 252.227-7013 and FAR
52.227-19.

Sun, Sun Microsystems and the Sun logo are trademarks or registered
trademarks of Sun Microsystems, Inc.

SunSoft, Inc.  
2550 Garcia Avenue 
Mountain View, California  94043

NOTE:

SunOS, SunSoft, Sun, Solaris, Sun Microsystems or the Sun logo are
trademarks or registered trademarks of Sun Microsystems, Inc.

 */

//#############################################################################

#include "be_classes.hh"

//=============================================================================
/*
 * Initialize the BE. The protocol requires only that this routine
 * return an instance of AST_Generator (or a subclass thereof).
 *
 * Remember that none of the FE initialization has been done, when you
 * add stuff here.
 */
AST_Generator*
BE_init()
{
	AST_Generator* g = new BE_Generator();

	if ( !g ) {
		cerr << GTDEVEL("IDL: BE init failed to create generator, exiting.")
			<< endl;
		exit(99);
	}
	return g;
}

//=============================================================================
// Implementation of BE generator class
// This implements the same protocol as AST_Generator but creates instances
// of the BE-subclassed classes instead of of AST classes

/*
 * Public operations
 */

/*
 * Construct an AST_PredefinedType node (a predefined type)
 */
AST_PredefinedType *
BE_Generator::create_predefined_type(AST_PredefinedType::PredefinedType t,
				    UTL_ScopedName *n,
				    UTL_StrList *p)
{
  return new BE_PredefinedType(t, n, p);
}

/*
 * Construct an AST_Module node (a module)
 */
AST_Module	*
BE_Generator::create_module(UTL_ScopedName *n, UTL_StrList *p)
{
  return new BE_Module(n, p);
}

/*
 * Construct an AST_Root node (a node representing the root of an AST)
 */
AST_Root *
BE_Generator::create_root(UTL_ScopedName *n,
			  UTL_StrList *p)
{
    return new BE_Root(n, p);
}

/*
 * Construct an AST_Interface node (an interface)
 */
AST_Interface	*
BE_Generator::create_interface(UTL_ScopedName *n,
			       AST_Interface **ih,
			       long nih,
			       UTL_StrList *p)
{
  return new BE_Interface(n, ih, nih, p);
}

/*
 * Construct an AST_InterfaceFwd node (a node representing the forward
 * declaration of an interface)
 */
AST_InterfaceFwd *
BE_Generator::create_interface_fwd(UTL_ScopedName *n, UTL_StrList *p)
{
  return new BE_InterfaceFwd(n, p);
}

/*
 * Construct an AST_Exception node (an exception)
 */
AST_Exception	*
BE_Generator::create_exception(UTL_ScopedName *n, UTL_StrList *p)
{
  return new BE_Exception(n, p);
}

/*
 * Construct an AST_Structure node (a struct)
 */
AST_Structure	*
BE_Generator::create_structure(UTL_ScopedName *n, UTL_StrList *p)
{
  return new BE_Structure(n, p);
}

/*
 * Construct an AST_Enum node (an enum)
 */
AST_Enum	*
BE_Generator::create_enum(UTL_ScopedName *n, UTL_StrList *p)
{
  return new BE_Enum(n, p);
}

/*
 * Construct an AST_Operation node (an operation on an interface)
 */
AST_Operation	*
BE_Generator::create_operation(AST_Type *rt,
			       AST_Operation::Flags fl,
			       UTL_ScopedName *n,
			       UTL_StrList *p)
{
  return new BE_Operation(rt, fl, n, p);
}

/*
 * Construct an AST_Field node (a field in a struct, union or exception)
 */
AST_Field	*
BE_Generator::create_field(AST_Type *ft, UTL_ScopedName *n, UTL_StrList *p)
{
  return new BE_Field(ft, n, p);
}

/*
 * Construct an AST_Argument node (an argument to an operation)
 */
AST_Argument	*
BE_Generator::create_argument(AST_Argument::Direction d,
			      AST_Type *ft,
			      UTL_ScopedName *n,
			      UTL_StrList *p)
{
  return new BE_Argument(d, ft, n, p);
}

/*
 * Construct an AST_Attribute node (an attribute)
 */
AST_Attribute	*
BE_Generator::create_attribute(idl_bool ro,
			       AST_Type *ft,
			       UTL_ScopedName *n,
			       UTL_StrList *p)
{
  return new BE_Attribute(ro, ft, n, p);
}

/*
 * Construct an AST_Union node (a union)
 */
AST_Union	*
BE_Generator::create_union(AST_ConcreteType *dt,
			   UTL_ScopedName *n,
			   UTL_StrList *p)
{
  return new BE_Union(dt, n, p);
}

/*
 * Construct an AST_UnionBranch node (a branch in a union)
 */
AST_UnionBranch *
BE_Generator::create_union_branch(AST_UnionLabel *lab,
				 AST_Type *ft,
				 UTL_ScopedName *n,
				 UTL_StrList *p)
{
  return new BE_UnionBranch(lab, ft, n, p);
}

/*
 * Construct an AST_UnionLabel node (a label in a union)
 */
AST_UnionLabel	*
BE_Generator::create_union_label(AST_UnionLabel::UnionLabel ul,
				AST_Expression *v)
{
  return new BE_UnionLabel(ul, v);
}

/*
 * Construct an AST_Constant node (a constant)
 */
AST_Constant	*
BE_Generator::create_constant(AST_Expression::ExprType et,
			      AST_Expression *ev,
			      UTL_ScopedName *n,
			      UTL_StrList *p)
{
  return new BE_Constant(et, ev, n, p);
}

/*
 * Construct an AST_Expression node denoting a symbolic name
 */
AST_Expression	*
BE_Generator::create_expr(UTL_ScopedName *n)
{
  return new BE_Expression(n);
}

/*
 * Construct an AST_Expression denoting a coercion
 */
AST_Expression	*
BE_Generator::create_expr(AST_Expression *v, AST_Expression::ExprType t)
{
  return new BE_Expression(v, t);
}

/*
 * Construct an AST_Expression node denoting a binary combinator
 * of two other AST_Expression nodes
 */
AST_Expression	*
BE_Generator::create_expr(AST_Expression::ExprComb c,
			   AST_Expression *v1,
			   AST_Expression *v2)
{
  return new BE_Expression(c, v1, v2);
}

/*
 * Construct an AST_Expression node denoting a long integer
 */
AST_Expression	*
BE_Generator::create_expr(long v)
{
  return new BE_Expression(v);
}

/*
 * Construct an AST_Expression node denoting a long integer being used
 * as a boolean
 */
AST_Expression	*
BE_Generator::create_expr(long v, AST_Expression::ExprType t)
{
  return new BE_Expression(v, t);
}

/*
 * Construct an AST_Expression node denoting an unsigned long integer
 */
AST_Expression	*
BE_Generator::create_expr(unsigned long v)
{
  return new BE_Expression(v);
}

/*
 * Construct an AST_Expression node denoting a string (a char *
 * encapsulated as String)
 */
AST_Expression	*
BE_Generator::create_expr(String *s)
{
  return new BE_Expression(s);
}

/*
 * Construct an AST_Expression node denoting a character
 */
AST_Expression	*
BE_Generator::create_expr(char c)
{
  return new BE_Expression(c);
}

/*
 * Construct an AST_Expression node denoting a 64-bit floating point number
 */
AST_Expression	*
BE_Generator::create_expr(double d)
{
  return new BE_Expression(d);
}

/*
 * Construct an AST_EnumVal node (an enumerator)
 */
AST_EnumVal	*
BE_Generator::create_enum_val(unsigned long v,
			     UTL_ScopedName *n,
			     UTL_StrList *p)
{
  return new BE_EnumVal(v, n, p);
}

/*
 * Construct an AST_Array node (an array type or field modifier)
 */
AST_Array	*
BE_Generator::create_array(UTL_ScopedName *n,
			   unsigned long ndims,
			   UTL_ExprList *dims)
{
  return new BE_Array(n, ndims, dims);
}

/*
 * Construct an AST_Sequence node (a sequence type definition)
 */
AST_Sequence	*
BE_Generator::create_sequence(AST_Expression *ms, AST_Type *bt)
{
  return new BE_Sequence(ms, bt);
}

/*
 * Construct an AST_String node (a string type definition)
 */
AST_String	*
BE_Generator::create_string(AST_Expression *ms)
{
  return new BE_String(ms);
}

/*
 * Construct an AST_String node denoting a wide string type definition
 */
AST_String	*
BE_Generator::create_wstring(AST_Expression *ms)
{
  return new BE_String(ms, sizeof(wchar_t));
}

/*
 * Construct an AST_Typedef node (a typedef)
 */
AST_Typedef	*
BE_Generator::create_typedef(AST_Type *bt, UTL_ScopedName *n, UTL_StrList *p)
{
  return new BE_Typedef(bt, n, p);
}

//#############################################################################

