/*-*- C++ -*-*/
//#############################################################################
//## File: IDLtoC/be_generic/be_classes.hh
//## Author: Jeremy Heiner
//## Organization: Georgia Institute of Technology
//## Copyright: see below
//## Purpose: declares all the generic back end classes
//#############################################################################
//## History: the front end was developed by SunSoft, see their copyright
//## message below.  Dilma Silva, also here at gatech, developed the code
//## into an idl2c compiler to support the COBS project.  i'm starting with
//## dilma's code.

/*

COPYRIGHT

Copyright 1992, 1993, 1994 Sun Microsystems, Inc.  Printed in the United
States of America.  All Rights Reserved.

This product is protected by copyright and distributed under the following
license restricting its use.

The Interface Definition Language Compiler Front End (CFE) is made
available for your use provided that you include this license and copyright
notice on all media and documentation and the software program in which
this product is incorporated in whole or part. You may copy and extend
functionality (but may not remove functionality) of the Interface
Definition Language CFE without charge, but you are not authorized to
license or distribute it to anyone else except as part of a product or
program developed by you or with the express written consent of Sun
Microsystems, Inc. ("Sun").

The names of Sun Microsystems, Inc. and any of its subsidiaries or
affiliates may not be used in advertising or publicity pertaining to
distribution of Interface Definition Language CFE as permitted herein.

This license is effective until terminated by Sun for failure to comply
with this license.  Upon termination, you shall destroy or return all code
and documentation for the Interface Definition Language CFE.

INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES OF
ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS
FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A COURSE OF
DEALING, USAGE OR TRADE PRACTICE.

INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED WITH NO SUPPORT AND WITHOUT
ANY OBLIGATION ON THE PART OF Sun OR ANY OF ITS SUBSIDIARIES OR AFFILIATES
TO ASSIST IN ITS USE, CORRECTION, MODIFICATION OR ENHANCEMENT.

SUN OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL HAVE NO LIABILITY WITH
RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
INTERFACE DEFINITION LANGUAGE CFE OR ANY PART THEREOF.

IN NO EVENT WILL SUN OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE FOR
ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL
DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

Use, duplication, or disclosure by the government is subject to
restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in
Technical Data and Computer Software clause at DFARS 252.227-7013 and FAR
52.227-19.

Sun, Sun Microsystems and the Sun logo are trademarks or registered
trademarks of Sun Microsystems, Inc.

SunSoft, Inc.  
2550 Garcia Avenue 
Mountain View, California  94043

NOTE:

SunOS, SunSoft, Sun, Solaris, Sun Microsystems or the Sun logo are
trademarks or registered trademarks of Sun Microsystems, Inc.

 */

//#############################################################################

#ifndef _BE_CLASSES_BE_CLASSES_HH
#define _BE_CLASSES_BE_CLASSES_HH

#include <idl.hh>
#include <idl_extern.hh>

//=============================================================================
// these are the AST/UTL classes that get subclassed,
//                                       // and the corresponding BE_ classes

#include <utl_scope.hh>                  // class BE_Scope
#include <ast_expression.hh>             // class BE_Expression
#include <ast_union_label.hh>            // class BE_UnionLabel

#include <ast_decl.hh>                   // class BE_Decl
#include <ast_constant.hh>               //== class BE_Constant
#include <ast_enum_val.hh>               //---- class BE_EnumVal
#include <ast_field.hh>                  //== class BE_Field
#include <ast_argument.hh>               //---- class BE_Argument
#include <ast_attribute.hh>              //---- class BE_Attribute
#include <ast_union_branch.hh>           //---- class BE_UnionBranch
#include <ast_module.hh>                 //== class BE_Module
#include <ast_root.hh>                   //---- class BE_Root
#include <ast_operation.hh>              //== class BE_Operation
#include <ast_type.hh>                   //== class BE_Type
#include <ast_concrete_type.hh>          //---- class BE_ConcreteType
#include <ast_array.hh>                  //         class BE_Array
#include <ast_enum.hh>                   //         class BE_Enum
#include <ast_predefined_type.hh>        //         class BE_PredefinedType
#include <ast_sequence.hh>               //         class BE_Sequence
#include <ast_string.hh>                 //         class BE_String
#include <ast_structure.hh>              //         class BE_Structure
#include <ast_exception.hh>              //             class BE_Exception
#include <ast_union.hh>                  //             class BE_Union
#include <ast_interface.hh>              //---- class BE_Interface
#include <ast_interface_fwd.hh>          //---- class BE_InterfaceFwd
#include <ast_typedef.hh>                //---- class BE_Typedef 

//#############################################################################

class BE_Scope
	: public virtual UTL_Scope
{
public:

	// Constructor
	virtual ~BE_Scope();

	// Narrowing
	DEF_NARROW_METHODS1( BE_Scope, UTL_Scope );
	DEF_NARROW_FROM_SCOPE( BE_Scope );

	// AST Dumping
	virtual void dump( ostream& );

	// hacks for be_errors macros
	long    line_hack();
	String *file_name_hack();

protected:

	// Constructor
	BE_Scope( AST_Decl::NodeType );

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Expression
	: public virtual AST_Expression
{
public:

	// Constructor
	BE_Expression( AST_Expression*, ExprType );
	BE_Expression( ExprComb, AST_Expression*, AST_Expression* );
	BE_Expression( short );
	BE_Expression( unsigned short );
	BE_Expression( long );
	BE_Expression( long, ExprType );
	BE_Expression( unsigned long );
	BE_Expression( float );
	BE_Expression( double );
	BE_Expression( char );
	BE_Expression( unsigned char );
	BE_Expression( String* );
	BE_Expression( UTL_ScopedName* );
	virtual ~BE_Expression();

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_UnionLabel
	: public virtual AST_UnionLabel
{
public:

	// Constructor
	BE_UnionLabel( UnionLabel, AST_Expression* value );
	virtual ~BE_UnionLabel();

	// AST Dumping
	virtual void dump( ostream& );

	// hacks for be_errors macros
	long    line()      { return label_val()->line(); }
	String *file_name() { return label_val()->file_name(); }

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Decl
	: public virtual AST_Decl
{
public:

	// Constructor
	virtual ~BE_Decl();

	// Narrowing
	DEF_NARROW_METHODS1( BE_Decl, AST_Decl );
	DEF_NARROW_FROM_DECL( BE_Decl );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// Constructor
	BE_Decl( NodeType, UTL_ScopedName*, UTL_StrList* pragmas );

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Constant
	: public virtual BE_Decl, public virtual AST_Constant
{
public:

	// Constructor
	BE_Constant( AST_Expression::ExprType, AST_Expression* value,
	             UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_Constant();

	// Narrowing
	DEF_NARROW_METHODS2( BE_Constant, BE_Decl, AST_Constant );
	DEF_NARROW_FROM_DECL( BE_Constant );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// Constructor
	BE_Constant( AST_Expression::ExprType, NodeType, AST_Expression*,
	             UTL_ScopedName*, UTL_StrList* );

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_EnumVal
	: public virtual BE_Constant, public virtual AST_EnumVal
{
public:

	// Constructor
	BE_EnumVal( unsigned long value, UTL_ScopedName*, UTL_StrList* pragmas);
	virtual ~BE_EnumVal();

	// Narrowing
	DEF_NARROW_METHODS2( BE_EnumVal, BE_Constant, AST_EnumVal );
	DEF_NARROW_FROM_DECL( BE_EnumVal );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Field
	: public virtual BE_Decl, public virtual AST_Field
{
public:

	// Constructor
	BE_Field( AST_Type* field_type, UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_Field();

	// Narrowing
	DEF_NARROW_METHODS2( BE_Field, BE_Decl, AST_Field );
	DEF_NARROW_FROM_DECL( BE_Field );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// Constructor
	BE_Field( NodeType, AST_Type*, UTL_ScopedName*, UTL_StrList* );

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Argument
	: public virtual BE_Field, public virtual AST_Argument
{
public:

	// Constructor
	BE_Argument( Direction, AST_Type* field_type,
	             UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_Argument();

	// Narrowing
	DEF_NARROW_METHODS2( BE_Argument, BE_Field, AST_Argument );
	DEF_NARROW_FROM_DECL( BE_Argument );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Attribute
	: public virtual BE_Field, public virtual AST_Attribute
{
public:

	// Constructor
	BE_Attribute( idl_bool readonly, AST_Type* field_type,
	              UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_Attribute();

	// Narrowing
	DEF_NARROW_METHODS2( BE_Attribute, BE_Field, AST_Attribute );
	DEF_NARROW_FROM_DECL( BE_Attribute );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_UnionBranch
	: public virtual BE_Field, public virtual AST_UnionBranch
{
public:

	// Constructor
	BE_UnionBranch( AST_UnionLabel*, AST_Type* field_type,
	                UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_UnionBranch();

	// Narrowing
	DEF_NARROW_METHODS2( BE_UnionBranch, BE_Field, AST_UnionBranch );
	DEF_NARROW_FROM_DECL( BE_UnionBranch );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Module
	: public virtual BE_Decl, public virtual BE_Scope,
	  public virtual AST_Module
{
public:

	// Constructor
	BE_Module( UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_Module();

	// Narrowing
	DEF_NARROW_METHODS3( BE_Module, BE_Decl, BE_Scope, AST_Module );
	DEF_NARROW_FROM_DECL( BE_Module );
	DEF_NARROW_FROM_SCOPE( BE_Module );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Root
	: public virtual BE_Module, public virtual AST_Root
{
public:

	// Constructor
	BE_Root( UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_Root();

	// Narrowing
	DEF_NARROW_METHODS2( BE_Root, BE_Module, AST_Root );
	DEF_NARROW_FROM_DECL( BE_Root );
	DEF_NARROW_FROM_SCOPE( BE_Root );

	// AST Dumping
	virtual void dump( ostream& );
	static void abort();

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Operation
	: public virtual BE_Decl, public virtual BE_Scope,
	  public virtual AST_Operation
{
public:

	// Constructor
	BE_Operation( AST_Type* return_type, AST_Operation::Flags,
	              UTL_ScopedName*, UTL_StrList *pragmas );
	virtual ~BE_Operation();

	// Narrowing
	DEF_NARROW_METHODS3( BE_Operation, BE_Decl, BE_Scope, AST_Operation );
	DEF_NARROW_FROM_DECL( BE_Operation );
	DEF_NARROW_FROM_SCOPE( BE_Operation );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Type
	: public virtual BE_Decl, public virtual AST_Type
{
public:

	// Constructor
	virtual ~BE_Type();

	// Narrowing
	DEF_NARROW_METHODS2( BE_Type, BE_Decl, AST_Type );
	DEF_NARROW_FROM_DECL( BE_Type );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// Constructor
	BE_Type( NodeType, UTL_ScopedName*, UTL_StrList* );

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_ConcreteType
	: public virtual BE_Type, public virtual AST_ConcreteType
{
public:

	// Constructor
	virtual ~BE_ConcreteType();

	// Narrowing
	DEF_NARROW_METHODS2( BE_ConcreteType, BE_Type, AST_ConcreteType );
	DEF_NARROW_FROM_DECL( BE_ConcreteType );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// Constructor
	BE_ConcreteType( NodeType, UTL_ScopedName*, UTL_StrList* );

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Array
	: public virtual BE_ConcreteType, public virtual AST_Array
{
public:

	// Constructor
	BE_Array( UTL_ScopedName*, unsigned long ndims, UTL_ExprList* dims );
	virtual ~BE_Array();

	// Narrowing
	DEF_NARROW_METHODS2( BE_Array, BE_ConcreteType, AST_Array );
	DEF_NARROW_FROM_DECL( BE_Array );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Enum
	: public virtual BE_ConcreteType, public virtual BE_Scope,
	  public virtual AST_Enum
{
public:

	// Constructor
	BE_Enum( UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_Enum();

	// Narrowing
	DEF_NARROW_METHODS3( BE_Enum, BE_ConcreteType, BE_Scope, AST_Enum );
	DEF_NARROW_FROM_DECL( BE_Enum );
	DEF_NARROW_FROM_SCOPE( BE_Enum );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_PredefinedType
	: public virtual BE_ConcreteType, public virtual AST_PredefinedType
{
public:

	// Constructor
	BE_PredefinedType( PredefinedType, UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_PredefinedType();

	// Narrowing
	DEF_NARROW_METHODS2( BE_PredefinedType, BE_ConcreteType, AST_PredefinedType );
	DEF_NARROW_FROM_DECL( BE_PredefinedType );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Sequence
	: public virtual BE_ConcreteType, public virtual AST_Sequence
{
public:

	// Constructor
	BE_Sequence( AST_Expression* max_size, AST_Type *base_type );
	virtual ~BE_Sequence();

	// Narrowing
	DEF_NARROW_METHODS2( BE_Sequence, BE_ConcreteType, AST_Sequence );
	DEF_NARROW_FROM_DECL( BE_Sequence );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_String
	: public virtual BE_ConcreteType, public virtual AST_String
{
public:

	// Constructor
	BE_String( AST_Expression* max_size );
	BE_String( AST_Expression* max_size, long width );
	virtual ~BE_String();

	// Narrowing
	DEF_NARROW_METHODS2( BE_String, BE_ConcreteType, AST_String );
	DEF_NARROW_FROM_DECL( BE_String );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Structure
	: public virtual BE_ConcreteType, public virtual BE_Scope,
	  public virtual AST_Structure
{
public:

	// Constructor
	BE_Structure( UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_Structure();

	// Narrowing
	DEF_NARROW_METHODS3( BE_Structure, BE_ConcreteType, BE_Scope, AST_Structure );
	DEF_NARROW_FROM_DECL( BE_Structure );
	DEF_NARROW_FROM_SCOPE( BE_Structure );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// Constructor
	BE_Structure( NodeType, UTL_ScopedName*, UTL_StrList* );

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Exception
	: public virtual BE_Structure, public virtual AST_Exception
{
public:

	// Constructor
	BE_Exception( UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_Exception();

	// Narrowing
	DEF_NARROW_METHODS2( BE_Exception, BE_Structure, AST_Exception );
	DEF_NARROW_FROM_DECL( BE_Exception );
	DEF_NARROW_FROM_SCOPE( BE_Exception );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

	// Scope Management Protocol
protected:
	virtual AST_Field       *fe_add_field(AST_Field *f);
	virtual AST_Union       *fe_add_union(AST_Union *u);
	virtual AST_Structure   *fe_add_structure(AST_Structure *s);
	virtual AST_Enum        *fe_add_enum(AST_Enum *e);
	virtual AST_EnumVal     *fe_add_enum_val(AST_EnumVal *v);
};

//=============================================================================

class BE_Union
	: public virtual BE_Structure, public virtual AST_Union
{
public:

	// Constructor
	BE_Union( AST_ConcreteType* disc_type,
	          UTL_ScopedName*, UTL_StrList *pragmas );
	virtual ~BE_Union();

	// Narrowing
	DEF_NARROW_METHODS2( BE_Union, BE_Structure, AST_Union );
	DEF_NARROW_FROM_DECL( BE_Union );
	DEF_NARROW_FROM_SCOPE( BE_Union );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

  // Scope Management Protocol
protected:
  virtual AST_Union		*fe_add_union(AST_Union			*u);
  virtual AST_Structure		*fe_add_structure(AST_Structure		*s);
  virtual AST_Enum		*fe_add_enum(AST_Enum			*e);
  virtual AST_EnumVal		*fe_add_enum_val(AST_EnumVal		*v);

};

//=============================================================================

class BE_Interface
	: public virtual BE_Type, public virtual BE_Scope,
	  public virtual AST_Interface
{
public:

	// Constructor
	BE_Interface( UTL_ScopedName*, AST_Interface** inherits,
	              long num_inherits, UTL_StrList* pragmas );
	virtual ~BE_Interface();

	// Narrowing
	DEF_NARROW_METHODS3( BE_Interface, BE_Type, BE_Scope, AST_Interface );
	DEF_NARROW_FROM_DECL( BE_Interface );
	DEF_NARROW_FROM_SCOPE( BE_Interface );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_InterfaceFwd
	: public virtual BE_Type, public virtual AST_InterfaceFwd
{
public:

	// Constructor
	BE_InterfaceFwd( UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_InterfaceFwd();

	// Narrowing
	DEF_NARROW_METHODS2( BE_InterfaceFwd, BE_Type, AST_InterfaceFwd );
	DEF_NARROW_FROM_DECL( BE_InterfaceFwd );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//=============================================================================

class BE_Typedef
	: public virtual BE_Type, public virtual AST_Typedef
{
public:

	// Constructor
	BE_Typedef( AST_Type* base_type, UTL_ScopedName*, UTL_StrList* pragmas );
	virtual ~BE_Typedef();

	// Narrowing
	DEF_NARROW_METHODS2( BE_Typedef, BE_Type, AST_Typedef );
	DEF_NARROW_FROM_DECL( BE_Typedef );

	// AST Dumping
	virtual void dump( ostream& );

protected:

	// error messages
	static const char* DUMP_NOT_IMPLEMENTED;

};

//#############################################################################

// Defines BE class for generator
// This defines the same protocol as the AST_Generator class but actually
// is implemented to create nodes of AST classes subclassed in this BE

class BE_Generator
   : public AST_Generator
{
public:
  // Operations

  // Create a node representing a predefined type
  virtual AST_PredefinedType
    *create_predefined_type(AST_PredefinedType::PredefinedType t,
			    UTL_ScopedName *n,
			    UTL_StrList *p);

  // Create a node representing a module
  virtual AST_Module	*create_module(UTL_ScopedName *n,
				       UTL_StrList *p);

  // Create a node representing a module which is the root of an AST
  virtual AST_Root	*create_root(UTL_ScopedName *n,
				     UTL_StrList *p);

  // Create a node representing an interface
  virtual AST_Interface	*create_interface(UTL_ScopedName *n,
					  AST_Interface **ih,
					  long nih,
					  UTL_StrList *p);

  // Create a node representing a forward declaration of an interface
  virtual AST_InterfaceFwd *create_interface_fwd(UTL_ScopedName *n,
						 UTL_StrList *p);

  // Create a node representing an exception
  virtual AST_Exception	*create_exception(UTL_ScopedName *n,
					  UTL_StrList *p);

  // Create a node representing a structure
  virtual AST_Structure	*create_structure(UTL_ScopedName *n,
					  UTL_StrList *p);

  // Create a node representing an enum
  virtual AST_Enum	*create_enum(UTL_ScopedName *n,
				     UTL_StrList *p);

  // Create a node representing an operation on an interface
  virtual AST_Operation	*create_operation(AST_Type *rt,
					  AST_Operation::Flags fl,
					  UTL_ScopedName *n,
					  UTL_StrList *p);

  // Create a node representing a field in a structure, exception or
  // union
  virtual AST_Field	*create_field(AST_Type *ft,
				      UTL_ScopedName *n,
				      UTL_StrList *p);

  // Create a node representing an argument to an operation
  virtual AST_Argument	*create_argument(AST_Argument::Direction d,
					 AST_Type *ft,
					 UTL_ScopedName *n,
					 UTL_StrList *p);

  // Create a node representing an attribute
  virtual AST_Attribute	*create_attribute(idl_bool ro,
					  AST_Type *ft,
					  UTL_ScopedName *n,
					  UTL_StrList *p);

  // Create a node representing a union
  virtual AST_Union	*create_union(AST_ConcreteType *dt,
				      UTL_ScopedName *n,
				      UTL_StrList *p);

  // Create a node representing one branch in a union
  virtual AST_UnionBranch *create_union_branch(AST_UnionLabel *lab,
					       AST_Type *ft,
					       UTL_ScopedName *n,
					       UTL_StrList *p);

  // Create a node representing a label on a union branch
  virtual AST_UnionLabel *create_union_label(AST_UnionLabel::UnionLabel ul,
					     AST_Expression *lv);

  // Create a node representing a constant
  virtual AST_Constant	*create_constant(AST_Expression::ExprType et,
					 AST_Expression *ev,
					 UTL_ScopedName *n,
					 UTL_StrList *p);

  // Create various kinds of nodes representing expressions
  virtual AST_Expression	*create_expr(UTL_ScopedName *n);
  virtual AST_Expression	*create_expr(AST_Expression *v,
					     AST_Expression::ExprType t);
  virtual AST_Expression	*create_expr(AST_Expression::ExprComb c,
					     AST_Expression *v1,
					     AST_Expression *v2);
  virtual AST_Expression	*create_expr(long v);
  virtual AST_Expression	*create_expr(long v,
					     AST_Expression::ExprType t);
  virtual AST_Expression	*create_expr(unsigned long v);
  virtual AST_Expression	*create_expr(String *s);
  virtual AST_Expression	*create_expr(char c);
  virtual AST_Expression	*create_expr(double d);

  // Create a node representing an enumerator
  virtual AST_EnumVal	*create_enum_val(unsigned long v,
					 UTL_ScopedName *n,
					 UTL_StrList *p);

  // Create a node representing an array type
  virtual AST_Array	*create_array(UTL_ScopedName *n,
				      unsigned long ndims,
				      UTL_ExprList *dims);

  // Create a node representing a sequence type
  virtual AST_Sequence	*create_sequence(AST_Expression *v,
					 AST_Type *bt);

  // Create a node representing a string type
  virtual AST_String	*create_string(AST_Expression *v);

  // Create a node representing a wide string type
  virtual AST_String	*create_wstring(AST_Expression *v);

  // Create a node representing a type renaming (typedef)
  virtual AST_Typedef	*create_typedef(AST_Type *bt,
					UTL_ScopedName *n,
					UTL_StrList *p);
};

//#############################################################################

#endif // _BE_CLASSES_BE_CLASSES_HH

