/*
 * be_utl.hh
 */

#ifndef _BE_UTL_HH
#define _BE_UTL_HH

// be_utl_att_list.hh
// 
// This class implementes a list of attributes, based on UTL_List

/* DEPENDECIES
**     utl_list.hh, be_classes.hh
** USE
**     Included in be_classes.hh; used by class be_interface
**
** Implementation based on UTL_IdList, in order to keep homogeneity.
*/

#include <utl_list.hh>

class be_attribute;
class be_operation;

class be_utl_att_list : public UTL_List 
{
public:
  // Constructor
  be_utl_att_list (be_attribute *att, be_utl_att_list *cdr);
  virtual ~be_utl_att_list() {}

  // get element
  be_attribute     *head();

private:
  be_attribute *pd_car_data;
};

// Active iterator for be_utl_att_list
class be_utl_att_listActiveIterator : public UTL_ListActiveIterator
{
public:
  // Constructor(s)
  be_utl_att_listActiveIterator(be_utl_att_list *list);
  
  be_attribute *item();
};
  
class be_utl_operation_list : public UTL_List 
{
public:
  // Constructor
  be_utl_operation_list (be_operation *att, be_utl_operation_list *cdr);
  virtual ~be_utl_operation_list() {}

  // get element
  be_operation     *head();

private:
  be_operation     *pd_car_data;
};

// Active iterator for be_utl_att_list
class be_utl_operation_listActiveIterator : public UTL_ListActiveIterator
{
public:
  // Constructor(s)
  be_utl_operation_listActiveIterator(be_utl_operation_list *list);
  
  be_operation *item();
};
  

#endif     //_BE_UTIL_HH
