/*
 * be_utl.cc
 */

// Implementation of a list of be_attributes and list of be_operations.
// Since I am building these using UTL_List (and following the way it
// was done for UTL_Idlist), the same NOTE about rely ing on a
// type-unsafe cast from UTL_List to subclasses (which will cease to
// operate correctly if we use eithter multiple or public virtual
// inheritance). For more details, see NOTE on utl_idlist.cc

#include <be_utl.hh>
#include <idl.hh>
#include <idl_extern.hh>


/* Class be_utl_att_list and its iterator */

/*
 * Constructor
 */

be_utl_att_list::be_utl_att_list(be_attribute *att, be_utl_att_list *cdr)
  : pd_car_data(att),
    UTL_List((UTL_List *) cdr)
{
}

/*
 * Public operations 
 */
be_attribute *
be_utl_att_list::head()
{
  return pd_car_data;
}


// be_utl_att_list Active Iterator

/*
 * Constructor
 */

be_utl_att_listActiveIterator::be_utl_att_listActiveIterator 
                    (be_utl_att_list  *l)
		      : UTL_ListActiveIterator(l)
{
}

/*
 * Public operations
 */

// Get current item
be_attribute *
be_utl_att_listActiveIterator::item()
{
    if (source == NULL)
        return NULL;
    return ((be_utl_att_list *) source)->head();
}



/* Class be_utl_operation_list and its iterator */

/*
 * Constructor
 */

be_utl_operation_list::be_utl_operation_list
  (be_operation *op, be_utl_operation_list *cdr)
    : pd_car_data(op),
      UTL_List((UTL_List *) cdr)
{
}

/*
 * Public operations 
 */
be_operation *
be_utl_operation_list::head()
{
  return pd_car_data;
}


// be_utl_operation_list Active Iterator

/*
 * Constructor
 */

be_utl_operation_listActiveIterator::be_utl_operation_listActiveIterator 
   (be_utl_operation_list     *l)
     : UTL_ListActiveIterator(l)
{
}

/*
 * Public operations
 */

// Get current item
be_operation *
be_utl_operation_listActiveIterator::item()
{
    if (source == NULL)
        return NULL;
    return ((be_utl_operation_list *) source)->head();
}

