/*
 * be_type_description.hh
 *
 * This file contains the interface for the object responsible for
 * keeping the list of complex type defined through the compilation. This
 * list is used to output in the desc file information about all complex
 * types "structure". This information is needed in order to generate code
 * for marshalling and unmarshalling arguments. 
 */

#ifndef _BE_TYPE_DESCRIPTION_HH
#define _BE_TYPE_DESCRIPTION_HH

#include <fstream.h>

class be_typeinfo {
public:
  be_typeinfo(char *typen, char *typeinfo);
  char *get_typename();
  char *get_typeinfo();
private:
  char *pd_typename;
  char *pd_typeinfo;
};


class be_complex_type_list {
public:
  // Operations
  be_complex_type_list();
  ~be_complex_type_list();

  void add(char *typen, char *typeinfo);
  void generate_description(ostream &o);

private:
  char search(char *typen);
  int     pd_list_size;
  be_typeinfo **pd_list;
};

extern be_complex_type_list *be_description_type_list;

#endif
