/* 
 * be_type_description.cc
 *
 * This class implements the class responsible for keeping the list of
 * complex types defined during compilation. This information will be
 * output in the desc file, and there it will be used in order to generate
 * code for marshalling and unmarshalling complex types. 
 */

#include   "be_type_description.hh"
#include   <malloc.h>
#include   <stdio.h>
#include   "assert.h"
#include   <string.h>

be_complex_type_list *be_description_type_list;

be_complex_type_list::be_complex_type_list()
  : pd_list_size(0),
    pd_list(NULL)
{
}

be_complex_type_list::~be_complex_type_list()
{
  for (int i=0; i<pd_list_size; i++)
    delete pd_list[i];
  free(pd_list);
}

void be_complex_type_list::add(char *typen, char *typeinfo)
{
  if (pd_list_size) {
    /* the list already exists */
    if (!search(typen)) {
      // insert
      pd_list_size++;
      pd_list = (be_typeinfo**) realloc(pd_list,
				     pd_list_size*sizeof(be_typeinfo*));
      assert(pd_list!=NULL);
      pd_list[pd_list_size-1] = new be_typeinfo(typen, typeinfo);
    }
  }
  else {
    /* first element in the list */
    pd_list_size++;
    pd_list = (be_typeinfo**) malloc(sizeof(be_typeinfo*));
    assert(pd_list!=NULL);
    pd_list[0] = new be_typeinfo(typen, typeinfo);
  }
  return;
}

char be_complex_type_list::search(char *typen)
{
  int i;
  for (i=0; i < pd_list_size; i++)
    if (strcmp(typen, pd_list[i]->get_typename()) == 0)
      return(1);
  return(0);
}

void be_complex_type_list::generate_description(ostream &o)
{
  o << "\n/* Generating description for complex defined types*/\n";
  for (int i=0; i < pd_list_size; i++) {
    o << "TYPEINFO " << pd_list[i]->get_typename() << " " 
      << pd_list[i]->get_typeinfo() << "\n";
  }
  o << "\n";
}


be_typeinfo::be_typeinfo(char *typen, char *typeinfo)
  : pd_typename(typen), 
    pd_typeinfo(typeinfo)
{
}

char *be_typeinfo::get_typename()
{
  return(pd_typename);
}


char *be_typeinfo::get_typeinfo()
{
  return(pd_typeinfo);
}


