/* 
 * be_translate.cc
 */

#include	<idl.hh>
#include	<idl_extern.hh>
#include	<be.hh>
#include        <be_translate.hh>
#include        <be_description.hh>
#include        <malloc.h>
#include        <assert.h>
#include        <unix_defs.h>
#include        "../config.h"


#define MAX_NAME_SIZE 255

/* the following macro declaration is used in
 * translate_from_inherited_interfaces. Due to hierarchy way of
 * defining things, I couldn't make it a function ...
 */
#define  DEFINE_TRANSL_UNDEFINE\
	  if (b == NULL) {                      \
	    cout << "Error in narrowing\n";     \
	    BE_abort();                         \
	  }                                     \
	  else {                                \
	    b->make_not_defined();              \
	    b->ctranslation(o);                 \
	    b->make_defined();                  \
	  }                             



/*
 * translate_scoped_name
 */

void translate_scoped_name( AST_Decl *d, ostream &o)
{
  be_idlist      namebe(d->name());
  namebe.ctranslation(o);
}

char *translate_scoped_name2dstring( AST_Decl *d)
{
  be_idlist      namebe(d->name());
  return namebe.ctranslation2dstring();
}

void
predefine_type(AST_Type *typ, ostream &o)
{
    AST_Type *tmp_type;
    int t;
    
    determine_specific_type(typ, &tmp_type, &t);
    switch(tmp_type->node_type()) {
    case AST_Decl::NT_sequence:
    {
	be_sequence *bseq;
	bseq = be_sequence::narrow_from_decl(tmp_type);
	if (!bseq->already_defined()) {
	    if (bseq->imported()) {
		bseq->build_type_info();
	    } else {
		tmp_type->ctranslation(o);
	    }
	}
	break;
    }
    case AST_Decl::NT_array:
    {
	be_array *barray;
	barray = be_array::narrow_from_decl(tmp_type);
	if (!barray->already_defined() && !barray->imported()) {
	    tmp_type->ctranslation(o);
	}
	break;
    }
    case AST_Decl::NT_struct:
    {
	be_structure *bstruct;
	bstruct = be_structure::narrow_from_decl(tmp_type);
	if (!bstruct->already_defined() && !bstruct->imported()) {
	    tmp_type->ctranslation(o);
	}
	break;
    }
    default:
	break;
    }
}

void
translate_field_types(UTL_Scope *s, ostream &o)
{
  UTL_ScopeActiveIterator	*i;
  AST_Decl			*d;
  AST_Field                     *f;
  
  i = new UTL_ScopeActiveIterator(s, UTL_Scope::IK_decls);

  while (!(i->is_done())) {
    d = i->item();

    // d is a field type, since we going through an structure.
    // I will, therefore, narrow it  ...
    if (d->node_type() == AST_Decl::NT_field) {
      f = AST_Field::narrow_from_decl(d);
      if (f==NULL) { // narrow failed
	cout << "ERROR: narrow failed in  translate_fields for struct\n";
	BE_abort();
      } else {
	  predefine_type(f->field_type(), o);
      }
    } else {
      cout << "ERROR: expected AST_Field in translate_fields for struct\n";
      BE_abort();
    }

    i->next();
  }
  delete i;
}

/*
 * translate_fields
 */
void 
translate_fields (UTL_Scope *s, ostream &o,
		  int *nb_fields, char ***array_field_description,
		  int do_output)
{
  UTL_ScopeActiveIterator	*i;
  AST_Decl			*d;
  AST_Field                     *f;
  
  // initializer counter of fields
  if (nb_fields != NULL)
    *nb_fields = 0;
  
  if (idl_global->indent() == NULL)
    idl_global->set_indent(new UTL_Indenter());

  idl_global->indent()->increase();

  i = new UTL_ScopeActiveIterator(s, UTL_Scope::IK_decls);

  while (!(i->is_done())) {
    d = i->item();
    if (do_output) idl_global->indent()->skip_to(o);
    // d is a field type, since we going through an structure.
    // I will, therefore, narrow it  ...
    if (d->node_type() == AST_Decl::NT_field) {
      f = AST_Field::narrow_from_decl(d);
      if (f==NULL) { // narrow failed
	cout << "ERROR: narrow failed in  translate_fields for struct\n";
	BE_abort();
      }
      else {
	AST_Type *tmp_type;
	int t;
	char *charcode;

	// Now we have the AST_field object, from which I can retrieve
	// the AST_type. But this retrieved AST_Type should be narrowed
	// down to AST_ConcreteType or typedef (the other 
	// possible AST_Type don't
	// make sense in this context). The routine translate_type
	// will take care of that.
	if (do_output) {
	  translate_type(f->field_type(), o);
	  o <<  f->local_name()->get_string();
	  /* In this case we	don't want the	scoped name */

	  o << ";\n";
	}

	// storing information about this field in the array_field_description
	if (array_field_description != NULL) {
	  // if the argument is NULL, no bookkeeping of field description is
	  // needed. Since it is not, we only need see if this is the first
	  // we need to alloc memory for the array
	  if (*nb_fields == 0) {
	    *array_field_description = (char **)malloc(sizeof(char*));
	  }
	  else {
	    // Notice that for SunOS 5.5 there won't be any need of separating
	    // these cases, since realloc can be called with ptr NULL
	    *array_field_description = (char **)
	                realloc(*array_field_description,
				sizeof(char*)*(*nb_fields+1));
	  }
	  assert(*array_field_description != NULL);
	  // since the fields have been "translate-type"-ed already, we
	  // known that even if it is a local type (like
	  // sequence<string,10>>) it now has a name. The only problem
	  // occurs when it is a pre_defined type, since we do not want a
	  // "long" as a type, the correct is "CORBA_long"
	  char *ftypename;
	  if (f->field_type()->node_type() == AST_Decl::NT_pre_defined) {
	    be_predefined_type *b;
	    b = be_predefined_type::narrow_from_decl(f->field_type());
	    if (b == NULL) {
	      // error in narrowing
	      assert(0);
	    }
	    else 
	      ftypename = b->ctranslation2dstring();
	  }
	  else {
	    // The following is probably wrong, ie, it does not cover
	    // the case were the scoped name is necessary!
	    //ftypename = f->field_type()->local_name()->get_string();
	    // 
	    // The following deals with scoped names
	    ftypename = translate_scoped_name2dstring(f->field_type());
	  }
	  
	  char *fname = f->local_name()->get_string();
	  assert(fname!=NULL);
	  /* determining fieldtypecode */
	  determine_specific_type(f->field_type(), &tmp_type, &t);
	  generate_typecode_2string(t, &charcode);
	  char *finfo = (char*) malloc(strlen("FIELDTYPE") + 1
				       + strlen(ftypename) + 1
				       +strlen("BASETYPECODE") + 1
				       + strlen(charcode) + 1 
				       + strlen("FIELDNAME") + 1
				       +strlen(fname)+1);
	  assert(finfo != NULL);
	  sprintf(finfo,"FIELDTYPE %s BASETYPECODE %s FIELDNAME %s", 
		  ftypename,  charcode, fname);
	  free(charcode);
	  (*array_field_description)[*nb_fields] = finfo;
	  (*nb_fields)++;
	} // end of array_field_description != NULL
      }
    }
    else { // this shouldn't happen
      cout << "ERROR: expected AST_Field in translate_fields for struct\n";
      BE_abort();
    }
    i->next();
  }
  delete i;

  idl_global->indent()->decrease();
}

/*
 * translate_type
 */
void
translate_type (AST_Type *ct, ostream &o)
{
  switch (ct->node_type()) {
  case AST_Decl::NT_interface:
  case AST_Decl::NT_typedef:
  case AST_Decl::NT_struct: 
    // just have to output the name of the typedef/interface/struct
    translate_scoped_name(ct, o);
    o << " " ;
    break;
  case AST_Decl::NT_pre_defined: 
  case AST_Decl::NT_array: 
  case AST_Decl::NT_enum: 
  case AST_Decl::NT_union: 
    // in all these previous cases we just have to translate the concretetype.
    ct->ctranslation(o);
    o << " ";
    break;
  case AST_Decl::NT_sequence: 
  case AST_Decl::NT_string: 
    ct->ctranslation(o);
    break;    
  default: // shouldnt' happen ...
    cout << "Error in translate_type: argument (value " << (int) ct->node_type()
	 << ") not a AST_ConcreteType\n";
    BE_abort();
  }
}

/*
 *  translate_typename_for_pure_name
 *
 * This function will translate the type without "CORBA" in front of it,
 * and types defined by typedefs will be translated in terms of its
 * basic type.  This is necessary while translating base types for
 * sequences or arrays.
 */
char *
translate_typename_for_pure_name (AST_Type *t, char *sout)
{
  if (sout == NULL) {
      sout = (char *) malloc(1);
      *sout = 0;
  }

  switch(t->node_type()) {
  case AST_Decl::NT_typedef:
    // Now we have to translate the base type. I used to do it like
    // "translate_type (base_type(), o)", but this may not work if the
    // sequence is a local declaration, because typedefs were not output
    // yet (they will  be only in the main declarations). So here we
    // force to have the typenames translated to their own base types.

    be_typedef *tdf;
    tdf = be_typedef::narrow_from_decl(t);
    if (tdf == NULL) {
      cout << "Error in translate_typename_for_pure_name while narrowing "
	   << "typedef\n";
      BE_abort();
    }
    sout = translate_typename_for_pure_name(tdf->base_type(), sout);
    break;
  case AST_Decl::NT_pre_defined: 
    be_predefined_type *pdt;
    pdt = be_predefined_type::narrow_from_decl( (AST_Decl *) t);
    if (pdt==NULL) { // narrow failed
      cout << "ERROR while narrowing in translate_typename_for_pure_name\n";
      BE_abort();
    }
    else {
      char *saux;
      saux = pdt->ctranslation2dstring();
      // the output came necessarily with "CORBA_" in the begining ...
      sout = (char *)realloc(sout, strlen(&saux[6]) + strlen(sout) + 1);
      strcat(sout, &saux[6]);
      free(saux);
    }
    break;
  case AST_Decl::NT_sequence:
#ifdef RIGHT
    if (strcmp(sout, "CORBA_sequence_")==0) {
      // it has been called recursively, so no need to the leading "CORBA"
      // Notice that if this functions is called from outside, the
      // argument sout  won't have this value, because even if it stores
      // the result of a previous call, this string is not valid as a
      // result of a call. 
      sout = (char *) realloc(sout, strlen(sout) + strlen("sequence_") + 1);
      strcat(sout, "sequence_");
    }
    else { // first call, has to start sout
      sout = (char *) realloc(sout, strlen(sout) + strlen("CORBA_sequence_") + 1);
      strcpy(sout, "CORBA_sequence_");

    }
#else
    sout = (char *) realloc(sout, strlen(sout) + strlen("sequence_") + 1);
    strcat(sout, "sequence_");
#endif

    be_sequence *beseq;
    beseq = be_sequence::narrow_from_decl(t);
    if (beseq==NULL) { // narrow failed
      cout << "Error while narrowing sequence in "
	   << "translate_typename_for_pure_name\n";
      BE_abort();
    }
    else 
      sout = translate_typename_for_pure_name(beseq->base_type(), sout);
    break;
  case AST_Decl::NT_string:
    be_string *bs;
    bs = be_string::narrow_from_decl(t);
    if (bs==NULL) {
      cout << "Error while narrowing sting in "
	   << "translate_typename_for_pure_name\n";
      BE_abort();
    }
    else {
      char digits[6];
      be_expr_val       expr(bs->max_size(), bs->max_size()->ev()->et);
      expr.value_only_2string_ctranslation(digits);
      sout = (char *) realloc(sout, strlen(sout) + strlen("string_") + strlen(digits) + 1);
      strcat(sout, "string_");
      strcat(sout, digits);
    }
    break;
  case AST_Decl::NT_interface:
  case AST_Decl::NT_struct:
    char *saux;
    saux = translate_scoped_name2dstring(t);
    sout = (char *)realloc(sout, strlen(saux) + strlen(sout) + 1);
    strcat(sout, saux);
    free(saux);
    break;
  case AST_Decl::NT_array:
    be_array *ba;
    ba = be_array::narrow_from_decl(t);
    if (ba==NULL) {
      cout << "Error while narrowing array in "
	   << "translate_typename_for_pure_name\n";
      BE_abort();
    }
    else {
      char *typename_var = NULL;
      char digits[6];
      typename_var = translate_typename_for_pure_name(ba->base_type(), NULL);
      sout = (char *) realloc(sout, strlen("CORBA_ARRAY_") + strlen(typename_var) + 1);
      strcpy(sout, "CORBA_array_");
      strcat(sout, typename_var);
      for (int i=0; i < ba->n_dims(); i++) {
	be_expr_val      expr(ba->dims()[i], ba->dims()[i]->ev()->et); 
	expr.value_only_2string_ctranslation(digits);
	sout = (char *) realloc(sout, strlen(digits) + strlen(sout) + 3);
	strcat(sout,"_");
	strcat(sout,digits);
	strcat(sout,"_");
      }
    }
    break;
  default: 
    cout << "Error in translate_typename_for_pure_name, type is " 
	 << (int)t->node_type() << "\n";
    BE_abort();
    }
  return sout;
}

/*
 * check_for_struct_base_type
 */
void 
check_for_struct_array_base_type(AST_Type *bt, ostream &o) 
{
  if (bt->node_type() == AST_Decl::NT_struct) {
    be_structure  *bst;
    bst = be_structure::narrow_from_decl(bt);
    if (bst == NULL) {
      cout << " Error while narrowing struct in check_for_struct_base_type\n";
      BE_abort();
    }
    else 
      if (!bst->already_defined()) {
	// We need to define this structure
	bst->ctranslation(o);
      }
  }
  if (bt->node_type() == AST_Decl::NT_array) {
    be_array  *ba;
    ba = be_array::narrow_from_decl(bt);
    if (ba == NULL) {
      cout << " Error while narrowing array in check_for_struct_base_type\n";
      BE_abort();
    }
    else 
      if (!ba->already_defined()) {
	// We need to define this structure
	ba->ctranslation(o);
	o << "\n";
      }
  }

}
/*
 * translate_scope_part
 */
void 
translate_scope_part( AST_Decl *d, char *st)
{
  be_idlist bename (d->name());
  bename.translate_scope_part(st);
}


/* 
 * translate_arguments
 */
void
translate_arguments(UTL_Scope *s, ostream &o)
{
  UTL_ScopeActiveIterator          *i;
  AST_Decl                         *d;
  be_argument                      *ba;
  int                              finished_arguments = 3;

  i = new UTL_ScopeActiveIterator (s, UTL_Scope::IK_decls);

  while (!(i->is_done())) {
    d = i->item();
    if (d->node_type() == AST_Decl::NT_argument) {
      ba = be_argument::narrow_from_decl(d);
      if (ba == NULL) {  // narrowing failed
	cout << "Error while narrowing in translate_arguments\n";
	BE_abort();
      }
      else {
	o << ", ";
	if (finished_arguments == 3) {
	  o << "\n\t";
	  finished_arguments = 0;
	}
	else
	  finished_arguments++;

	ba->ctranslation(o);
      }
      i->next();
    }
  }
  delete i;
}

void
translate_argument_types(UTL_Scope *s, ostream &o)
{
  UTL_ScopeActiveIterator          *i;
  AST_Decl                         *d;
  be_argument                      *ba;

  i = new UTL_ScopeActiveIterator (s, UTL_Scope::IK_decls);

  while (!(i->is_done())) {
    d = i->item();
    if (d->node_type() == AST_Decl::NT_argument) {
      ba = be_argument::narrow_from_decl(d);
      if (ba == NULL) {  // narrowing failed
	cout << "Error while narrowing in translate_arguments\n";
	BE_abort();
      }
      else {
	AST_Type *type = ba->field_type();
	AST_Type *tmp_type;
	int      node_type;

	// If it is a typedef or something like that, needs to nail town to
	// basic type so we can know what to do.
	determine_specific_type(type, &tmp_type, &node_type);

	switch(tmp_type->node_type()) {
	case AST_Decl::NT_sequence:
	{
	    be_sequence *bseq;
	    bseq = be_sequence::narrow_from_decl(tmp_type);
	    if (!bseq->already_defined() && !bseq->imported()) {
		tmp_type->ctranslation(o);
	    }
	    break;
	}
	case AST_Decl::NT_array:
	{
	    be_array *barray;
	    barray = be_array::narrow_from_decl(tmp_type);
	    if (!barray->already_defined() && !barray->imported()) {
		tmp_type->ctranslation(o);
	    }
	    break;
	}
	case AST_Decl::NT_struct:
	{
	    be_structure *bstruct;
	    bstruct = be_structure::narrow_from_decl(tmp_type);
	    if (!bstruct->already_defined() && !bstruct->imported()) {
		tmp_type->ctranslation(o);
	    }
	    break;
	}
	default:
	    break;
	}
      }
      i->next();
    }
  }
  delete i;
}

/*
 * translate_union_branches
 */
void
translate_union_branches(UTL_Scope *s, ostream &o)
{
  UTL_ScopeActiveIterator	*i;
  AST_Decl			*d;
  AST_UnionBranch               *b;

  idl_global->indent()->increase();

  i = new UTL_ScopeActiveIterator(s, UTL_Scope::IK_decls);

  while (!(i->is_done())) {
    d = i->item();
    idl_global->indent()->skip_to(o);
    // d is a union branch, since we going through an union
    // I will, therefore, narrow it  ...
    if (d->node_type() == AST_Decl::NT_union_branch) {
      b = AST_UnionBranch::narrow_from_decl(d);
      if (b==NULL) { // narrow failed
	cout << "ERROR: narrow failed in  translate_union_branches\n";
	BE_abort();
      }
      else {
	b->ctranslation(o);
      }
    }
    else { // this shouldn't happen
      cout << "ERROR: expected AST_UnionBranch in translate_union_branches\n";
      BE_abort();
    }
    i->next();
  }
  delete i;

  idl_global->indent()->decrease();
}


/*
 * translate_for_inherited_interfaces
 */
void
translate_for_inherited_interfaces( be_interface *inheriting,
				    AST_Interface **inheritance_from_array,
				    int  nb_inherits,
				    ostream &o)
{
  AST_Interface                      *itfc;
  UTL_ScopeActiveIterator            *i;
  AST_Decl                           *d;

  for (int j=0; j < nb_inherits; j++) {
    itfc = inheritance_from_array[j];
    
    o << "\n/* Inheriting definitions from interface "
      << itfc->local_name()->get_string() 
      << " */\n";

    // There is explanation about why the following way to deal
    // with inheritance works in file "idl2c.tex"
    
    // Let's go through itfc's declarations, changing its
    // interfacename, and then outputing it. Afterwards, the original
    // name is restored.

    i = new UTL_ScopeActiveIterator(itfc, UTL_Scope::IK_decls);
    while (!(i->is_done())) {
      d = i->item();    // current declaration
      
      // Now we need to check if this declaration is being redefined
      // somewhere down the hierarchy
      if (!(inheriting->is_already_defined(d->local_name()))) {
	UTL_ScopedName                  *originalname = d->name();
	UTL_ScopedName *newname, *item_name;

	// Temporarily change the decl's name to the inheriting interface's
	// name plus the decl's local name.  Save the old name and change
	// it back later.
	newname = (UTL_IdList*) inheriting->name()->copy();
	item_name = new UTL_ScopedName(i->item()->name()->last_component(), 
				       NULL);
	newname->nconc(item_name);
	d->set_name(newname); 
	// Before performing the actual generation for this inherited
	// definition, I need to make sure it will be done. For
	// example, if it is a structure a priori it won't redefine
	// it, since be_structure::ctranslation first check to see it
	// the stuff was already defined (if so, just the name of the
	// structure is output. So let's fake it "brand new state" if
	// needed, and then restore to whatever it is 
	switch (d->node_type()) {
	case AST_Decl::NT_struct: {
	  be_structure *b;
	  b = be_structure::narrow_from_decl(d);
	  DEFINE_TRANSL_UNDEFINE;
	  break;
	}
	case AST_Decl::NT_enum: {
	  be_enum *b;
	  b = be_enum::narrow_from_decl(d);
	  DEFINE_TRANSL_UNDEFINE;
	  break;
	}
	case AST_Decl::NT_union: {
	  be_union *b;
	  b = be_union::narrow_from_decl(d);
	  DEFINE_TRANSL_UNDEFINE;
	  break;
	}
	case AST_Decl::NT_string: {
	  be_string *b;
	  b = be_string::narrow_from_decl(d);
	  DEFINE_TRANSL_UNDEFINE;
	  break;
	}
	case AST_Decl::NT_sequence: {
	  be_structure *b;
	  b = be_structure::narrow_from_decl(d);
	  DEFINE_TRANSL_UNDEFINE;
	  break;
	}
	default:
	  // there is one more case (besides those enumerated in
	  // "case" that keeps "already_defined" info: intefaces. But
	  // we assume no interface nesting, so no worry about it.
	  d->ctranslation(o);
	  
	  // Each interface keeps list  of its attributes and operations, so
	  // attribute manipulation code can be generated
	  if (d->node_type()==AST_Decl::NT_attr) {
	    be_attribute *b;
	    b = be_attribute::narrow_from_decl(d);
	    if (b==NULL) { // error while narrowing
	      cout << "Error while narrowing attribute in "
		   << "translate_for_inherited_interfaces\n";
	      BE_abort();
	    } else { // narrowing went ok
	      b->set_mirror(inheriting->is_mirror());
	      inheriting->add_to_list_of_attribs(b);
	    }
	  }
	  if (d->node_type()==AST_Decl::NT_op) {
	    be_operation *b;
	    b = be_operation::narrow_from_decl(d);
	    if (b==NULL) { // error while narrowing
	      cout << "Error while narrowing operation in "
		   << "translate_for_inherited_interfaces\n";
	      BE_abort();
	    } else  {// narrowing went ok
	      b->set_mirror(inheriting->is_mirror());
	      inheriting->add_to_list_of_operations(b);
	    }
	  }
	};
	// change back to the original name
	d->set_name(originalname);

	// keep the information that this declaration was added to
	// "inheriting" interface
	inheriting->add_to_list_of_definitions(d->local_name());
      }
      else 
      i->next();
    } // end of while(!i->is_done() 
    delete i;
    

    // check if itfc itself inherits fromother classes, since all base
    // classes (not only the direct one, like iftc) should generate
    // definitions
    if (itfc->n_inherits() > 0)
      translate_for_inherited_interfaces(inheriting,
					 itfc->inherits(),
					 itfc->n_inherits(),
					 o);
  } // end of for(j=0; ...)

} // end of translate_for_inherited_interfaces
	



