/* 
 * be_produce.cc
 *
 * This is part of Georgia Tech COBS project's IDL to C compiler
 * implementation. This implementation was built on top of the compiler
 * front end freely available from SunSoft, therefore we include here
 * their copyright notice.
 *
 */



/*

COPYRIGHT

Copyright 1992, 1993, 1994 Sun Microsystems, Inc.  Printed in the United
States of America.  All Rights Reserved.

This product is protected by copyright and distributed under the following
license restricting its use.

The Interface Definition Language Compiler Front End (CFE) is made
available for your use provided that you include this license and copyright
notice on all media and documentation and the software program in which
this product is incorporated in whole or part. You may copy and extend
functionality (but may not remove functionality) of the Interface
Definition Language CFE without charge, but you are not authorized to
license or distribute it to anyone else except as part of a product or
program developed by you or with the express written consent of Sun
Microsystems, Inc. ("Sun").

The names of Sun Microsystems, Inc. and any of its subsidiaries or
affiliates may not be used in advertising or publicity pertaining to
distribution of Interface Definition Language CFE as permitted herein.

This license is effective until terminated by Sun for failure to comply
with this license.  Upon termination, you shall destroy or return all code
and documentation for the Interface Definition Language CFE.

INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED AS IS WITH NO WARRANTIES OF
ANY KIND INCLUDING THE WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS
FOR A PARTICULAR PURPOSE, NONINFRINGEMENT, OR ARISING FROM A COURSE OF
DEALING, USAGE OR TRADE PRACTICE.

INTERFACE DEFINITION LANGUAGE CFE IS PROVIDED WITH NO SUPPORT AND WITHOUT
ANY OBLIGATION ON THE PART OF Sun OR ANY OF ITS SUBSIDIARIES OR AFFILIATES
TO ASSIST IN ITS USE, CORRECTION, MODIFICATION OR ENHANCEMENT.

SUN OR ANY OF ITS SUBSIDIARIES OR AFFILIATES SHALL HAVE NO LIABILITY WITH
RESPECT TO THE INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY
INTERFACE DEFINITION LANGUAGE CFE OR ANY PART THEREOF.

IN NO EVENT WILL SUN OR ANY OF ITS SUBSIDIARIES OR AFFILIATES BE LIABLE FOR
ANY LOST REVENUE OR PROFITS OR OTHER SPECIAL, INDIRECT AND CONSEQUENTIAL
DAMAGES, EVEN IF SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

Use, duplication, or disclosure by the government is subject to
restrictions as set forth in subparagraph (c)(1)(ii) of the Rights in
Technical Data and Computer Software clause at DFARS 252.227-7013 and FAR
52.227-19.

Sun, Sun Microsystems and the Sun logo are trademarks or registered
trademarks of Sun Microsystems, Inc.

SunSoft, Inc.  
2550 Garcia Avenue 
Mountain View, California  94043

NOTE:

SunOS, SunSoft, Sun, Solaris, Sun Microsystems or the Sun logo are
trademarks or registered trademarks of Sun Microsystems, Inc.

 */

#pragma ident "%@(#)BE_produce.cc	1.16% %92/06/10% Sun Microsystems"

// BE_produce.cc - Produce the work of the BE - does nothing in the
//		   dummy BE

#include	<idl.hh>
#include	<idl_extern.hh>
#include	<be.hh>
#include        <be_description.hh>
#include        <fstream.h>
#include	<assert.h>
#include	<stdio.h>
#include        "be_type_description.hh"
#include	"be_translate.hh"

void BE_go_through_declarations(  UTL_ScopeActiveIterator    *i, 
				  ostream &fout, ostream &descout);

void
dotIDL2dotC(char *originalfilename, char *cfilename) 
{
   int                        where;
   where = strlen(originalfilename) - 4; // 4 is the length of ".idl"
  if (where >= 0 && strcmp(".idl", (char *) &originalfilename[where]) == 0) {
    // ".idl" does occur in the end the file name
    strncpy(cfilename, originalfilename, where);
    cfilename[where] = '\0'; // null terminating it
    strcat(cfilename, ".h");
  }
  else {
    // .idl not found in the end of filename
    strcpy(cfilename, originalfilename);
    strcat(cfilename, ".h");
  }
  
}

void
translate_local_types(UTL_Scope *root, ostream &fout)
{
    UTL_ScopeActiveIterator    *i;
    AST_Decl			*d;

    i = new UTL_ScopeActiveIterator(root, UTL_Scope::IK_localtypes);
    fout << GTDEVEL("\n/* Locally defined types (if any): */\n");
    while (!(i->is_done())) {
	d = i->item();       // got the AST_Decl
	//  GSE -  Lots of stuff used to be handled here, but all cases
	//  didn't really work.  So, now we just handle string types.
	//  Other "local types" are handled prior to their use.
	//  Declarations are generated by translate_field_types() and
	//  translate_argument_types(). 
	
	switch (d->node_type()) {
	case AST_Decl::NT_string:
	    if (!d->imported()) { 
		d->ctranslation(fout);
	    } else {
		be_string *b;
		b = be_string::narrow_from_decl(d);
		b->make_defined();
	    }
	    break;
	case AST_Decl::NT_struct: {
	    if (d->imported()) {
		be_structure *b;
		b = be_structure::narrow_from_decl(d);
		b->make_defined();
	    }
	    break;
	}
	case AST_Decl::NT_enum: {
	    if (d->imported()) {
		be_enum *b;
		b = be_enum::narrow_from_decl(d);
		b->make_defined();
	    }
	    break;
	}
	case AST_Decl::NT_union: {
	    if (d->imported()) {
		be_union *b;
		b = be_union::narrow_from_decl(d);
		b->make_defined();
	    }
	    break;
	}
	case AST_Decl::NT_sequence: {
	    if (d->imported()) {
		be_sequence *b;
		b = be_sequence::narrow_from_decl(d);
		b->make_defined();
	    }
	    break;
	}
	case AST_Decl::NT_array: {
	    if (d->imported()) {
		be_array *b;
		b = be_array::narrow_from_decl(d);
		b->make_defined();
	    }
	    break;
	}
	default:
	    cout << "case not handled in local types\n";
	    break;
	}
	i->next();
    }
    delete i;
}

/*
 * Do the work of this BE. 
 */
void
BE_produce()
{
  char                      *originalfilename 
                              = idl_global->main_filename()->get_string();
  char                       hfilename[255], descfilename[255];
  ofstream                   fout, descout;
  UTL_ScopeActiveIterator    *i;
  AST_Root                   *root;
  
  /* I first coded this part using libg++ class String, making things
   *  very easy through the use of methods 'index', 'before' ... But
   *  then I realized that class UTL_String actually overrides String
   *  definition :-(
   */

  // We need to get the file name right, ie, for "example.idl" we
  // want to generate the file "example.h".
  dotIDL2dotC(originalfilename, hfilename);

  /* Opening file for the .h output */
  fout.open(hfilename);
  if (fout == NULL) {
    cout << "\n ERROR: File " << hfilename << "cant' be created.\n";
    BE_abort();
  }
  fout << "/* File " << hfilename << "*/\n";
  fout << "/* This file contains the C mapping for the interfaces in \n   "
       << originalfilename << "*/\n\n";
  strcpy(descfilename, hfilename);             
  descfilename[strlen(hfilename) - 2] = '\0';  /* This is because we can't
						  have something like 
						  "#ifndef _IDLtoC_file.h" */
  /* Simillarly, the name can't be like "_IDLtoC_../file_H" */
  {
    int j;
    j = strlen(descfilename)-1;
    while (j>=0 && descfilename[j] != '.' && descfilename[j] != '/')
      j--;
    j++;
    fout << "#ifndef _IDLtoC_" << &descfilename[j] << "_H\n";
    fout << "#define _IDLtoC_" << &descfilename[j] << "_H\n\n";
    fout << "#ifndef CORBA_short\n";
    fout << "#define CORBA_short               short\n";
    fout << "#define CORBA_unsigned_short      unsigned short\n";
    fout << "#define CORBA_long                long\n";
    fout << "#define CORBA_unsigned_long       unsigned long\n";
    fout << "#define CORBA_float               float\n";
    fout << "#define CORBA_double              double\n";
    fout << "#define CORBA_boolean             char\n";
    fout << "#define CORBA_char                char\n";
    fout << "#define CORBA_octet               int\n";
    fout << "#define CORBA_enum                long\n";
    fout << "#define CORBA_void   void\n";
    fout << "#endif\n";
  }
  // Opening file for interface description output, ie, what attributes
  // and operations are associated to each interface. This description
  // will be then used to generate code for the attribute manipulation
  // and stubs for operations. This is separated of the translation
  // since it is dependent on the object model. 
  // 
  // In the future this should be done through an CORBA compliant
  // Interface Repository. By now we will only generate simple string
  // descriptions. 
  strcpy(descfilename, hfilename);
  descfilename[strlen(descfilename)-1] = 'd'; // replaces .h by .d 
                                              // (from .desc)
  strcat(descfilename, "esc");
  descout.open(descfilename);
  if (descout == NULL) {
    cout << "\n ERROR: File " << descfilename << "cant' be created.\n";
    BE_abort();
  }
  descout << "/* File " << descfilename << "*/\n";
  descout << "/* This file contains the descriptions of "
	   << "interfaces in \n   "
	   << originalfilename << "*/\n\n";

  // Check if there are files to be included in the idl specification.
  char fname[255];
  for (int j=0; j<idl_global->n_include_file_names(); j++) {
    fout << "#include \"";
    dotIDL2dotC(idl_global->include_file_names()[j]->get_string(), fname);
    fout << fname << "\"\n";
  } 

  // The following call initializes the object that keeps the list of
  // complex types beind defined. Notice that this information is needed
  // in order to ouput type information in the description file
  // (descout). For a long time we lived ok without having to deal with
  // detailed information about complex types, but the information
  // became necessary in order to generate code for marshalling and
  // unmarshalling parameteres (in COBS/COBS_Object_Model/code_gen).
  // As the compilation progress and type information is identified, the
  // code through be_classes.cc calls the method for the following
  // object that keeps the information about type. Notice that the list
  // won't have any repetition (differently from list of locally defined
  // types kept by the compiler itself) and that order is important.
  be_description_type_list = new be_complex_type_list();


  /* The following code is based on UTL_Scope::dump() */
  root = idl_global->root();

  /* Start the translation with the local types */
  descout << "/* Locally Defined Types */\n";
  translate_local_types(root, fout);

  i = new UTL_ScopeActiveIterator(root, UTL_Scope::IK_decls);
  BE_go_through_declarations(i, fout, descout);
  delete i;
  
  // output type information in desc file
  be_description_type_list->generate_description(descout);
  delete be_description_type_list;

  fout << "#endif      /* _IDLtoC_" << hfilename << "*/\n\n";
  fout << "/* end of " << hfilename << " */\n";
  fout.close();
  descout << "/* end of " << descfilename << " */\n";
  descout.close();
}

/*
 * Abort this run of the BE
 */
void
BE_abort()
{
  cout << "Aborting execution\n";
  exit(1);
}

extern void
generate_typecode(int code, ostream &o);

void BE_go_through_declarations(   UTL_ScopeActiveIterator    *i, 
				   ostream &fout, ostream &descout)
{
  AST_Decl                   *d;
  fout << GTDEVEL("\n/* Declarations (if any): */\n");
  while (!(i->is_done())) {
    d = i->item();
    if (!d->imported()) {
      switch (d->node_type()) {   // Not always the declaration will
	                          // output, and not always we want 
	                          // to output ";"
      case  AST_Decl::NT_const:
      case  AST_Decl::NT_enum_val:
	d->ctranslation(fout);
	break;
      case AST_Decl::NT_struct:
	// The following isolation of the case where the declaration is
	// a structure is necessary because the structure may have been
	// used in a local type (a sequence, for example), and therefore it
	// shouldn't be translated now.
	be_structure *b;
	b = be_structure::narrow_from_decl(d);
	if (b==NULL) {
	  cout << "Error while narrowing structure in be_produce\n";
	  BE_abort();
	}
	else
	  if (!b->already_defined()) {
	    d->ctranslation(fout);
	  }
	break;
      case  AST_Decl::NT_interface:
	d->ctranslation(fout);
	// The list of attributes associated to this interface was
	// kept. Now the code for the attribute manipulations are
	// generated.
	be_interface     *itfc;
	char *itfc_name;
	itfc = be_interface::narrow_from_decl(d);
	if (itfc == NULL) {    // error during narrowing
	  cout << "Error while narrowing interface in be_produce.cc.\n";
	  BE_abort();
	};
	// everything ok
	itfc_name = translate_scoped_name2dstring(itfc);
	descout << "\n/* Description for interface "
	  << itfc_name << "\n */\n\n";
	
	descout << "Interface " << itfc_name;
	if (itfc->is_mirror()) {
	  char *inherits_name = translate_scoped_name2dstring(itfc->inherits()[0]);
	  descout << " MIRROR " << inherits_name;
	  free(inherits_name);
	}
	descout << "\n";
	free(itfc_name);

	generate_attrib_description(itfc, descout);
	// The same for operations
	generate_operation_description(itfc, descout);
	break;	
      case AST_Decl::NT_module:
	be_module   *mdl;
	mdl = be_module::narrow_from_decl(d);
	if (mdl == NULL){    // error during narrowing
	  cout << "Error while narrowing module in be_produce.cc.\n";
	  BE_abort();
	};
	// everything ok 
	mdl->ctranslation2(fout,descout);
	break;
      default:
	d->ctranslation(fout);
      }
    } else {
      switch (d->node_type()) {   // Not always the declaration will
	                          // output, and not always we want 
	                          // to output ";"
      case  AST_Decl::NT_const:
      case  AST_Decl::NT_enum_val:
	break;
      case AST_Decl::NT_struct:
	be_structure   *structure;
	structure = be_structure::narrow_from_decl(d);
	structure->build_type_info();
	break;
      case  AST_Decl::NT_interface:
	be_interface   *interface;
	interface = be_interface::narrow_from_decl(d);
	interface->build_type_info();
	break;	
      case AST_Decl::NT_module:
	UTL_ScopeActiveIterator    *i;
	be_module   *mdl;
	mdl = be_module::narrow_from_decl(d);
	i = new UTL_ScopeActiveIterator(mdl, UTL_Scope::IK_decls);
	BE_go_through_declarations(i, fout, descout);
	delete i;
	break;
      case AST_Decl::NT_typedef:
	be_typedef   *td;
	td = be_typedef::narrow_from_decl(d);
	td->build_type_info();
	break;	
      case AST_Decl::NT_except:
	be_exception  *except;
	except = be_exception::narrow_from_decl(d);
	except->build_type_info();
	break;
      case AST_Decl::NT_pre_defined:
	break;
      case AST_Decl::NT_enum:
	be_enum   *en;
	en = be_enum::narrow_from_decl(d);
	en->build_type_info();
	break;	
      case AST_Decl::NT_array:
	be_array   *arr;
	arr = be_array::narrow_from_decl(d);
	arr->build_type_info();
	break;	
      case AST_Decl::NT_sequence:
	be_sequence   *seq;
	seq = be_sequence::narrow_from_decl(d);
	seq->build_type_info();
	break;	
      default:
	assert(0);
      }
    }
    i->next();
  }

}
