/*
 * be_generate.cc
 */

#include <be_generate.hh>
#include <be_translate.hh>
#include <be_classes.hh>
#include <idl.hh>
#include <idl_extern.hh>
#include <stdio.h>

/*
** generate_attrib_manipulation
**/

void
generate_attrib_manipulation (be_interface *itfc, ostream &o)
{
  be_utl_att_listActiveIterator          *i;

  o << "\n/* Definition for structure of attributes (to be part of\n"
    << " * CORBA_object structure) for interface "
    << itfc->local_name()->get_string() << "\n */\n\n";
  o << "typedef struct {\n";

  i = new be_utl_att_listActiveIterator(itfc->get_list_of_attribs());

  while ((!(i->is_done()))) {
    o << "\t";
    translate_type (i->item()->field_type(), o);
    o << i->item()->local_name()->get_string() << ";\n";
    i->next();
  }

  delete i;  

  o << "} _IDLtoC_" << itfc->local_name()->get_string() 
    << "_attrib_struct;\n\n";

  /* generating  the body for set/get functions */
  
  i = new be_utl_att_listActiveIterator(itfc->get_list_of_attribs());
  be_attribute *att;
  char *attscope;
  char returnstring[255];

  if (idl_global->indent() == NULL)
    idl_global->set_indent(new UTL_Indenter());

  while ((!(i->is_done()))) {
    att = i->item();
    o << "/*\n"
      << " * \"get\" function for attribute " <<att->local_name()->get_string()
      << "\n */\n\n";

    translate_type (att->field_type(), o);
    o << " ";
   
    be_idlist namebe (att->name());
    // The following assignment only works because we don't have
    // nested interfaces, so the scope for the attribute is just
    // interface.
    attscope = itfc->local_name()->get_string();
    o << attscope << "__get_" << att->local_name()->get_string() << "("
      << attscope << " o, CORBA_Environment *ev)\n"
      << "{\n";
    sprintf(returnstring, "((_IDLtoC_%s_attrib_struct *)o->attrib_struct)->", 
	    itfc->local_name()->get_string());
    strcat(returnstring, att->local_name()->get_string());
    idl_global->indent()->increase();
    generate_return(returnstring, att->field_type(), o);
    o << "}\n\n";
    idl_global->indent()->decrease();
    if (!(att->readonly())) {
      o << "/*\n"
	<<" * \"set\" function for attribute "<<att->local_name()->get_string()
	<< "\n */\n\n"
	<< "void\n";
      o << attscope << "__set_" << att->local_name()->get_string() 
	<< "(" << attscope << " o, CORBA_Environment *ev, ";
      translate_type (att->field_type(), o);
      o << " value)\n"
	<< "{\n";
      idl_global->indent()->increase();
      generate_assignment(returnstring, "value", att->field_type(), o);
      idl_global->indent()->decrease();
      o << "}\n\n";
    }
    i->next();
  }

  delete i;  
}

/*
 * generate_assignment (a, b, type, out)
 *
 * This routine outputs in "out" the code for "a = b". Notice
 * that how this is accomplished depends on the specific type.
 * For basic types such as CORBA_char,  CORBA_long, we can do
 * assignment. But for strings, sequences, arrays, etc, type
 * specific operations have to be done.
 */

void
generate_assignment (char *left_side, char *right_side,
		       AST_Type *type, ostream &o)
{
  switch (type->node_type()) {
  case AST_Decl::NT_typedef:
    AST_Typedef *def;
    def = AST_Typedef::narrow_from_decl(type);
    if (def == NULL) {
      cout << "Narrowing failed in generate_assignment\n";
      BE_abort();
    }
    else
      generate_assignment(left_side, right_side, def->base_type(),o);
    break;
  case AST_Decl::NT_enum:
  case AST_Decl::NT_pre_defined:
  case AST_Decl::NT_struct:
    idl_global->indent()->skip_to(o);
    o << left_side << " = " << right_side << ";\n";
    break;
  case AST_Decl::NT_string:
  case AST_Decl::NT_array:
    cout << "generate_assignemnt: implementation for"
	 << "string, array not done yet\n";
    BE_abort();
    break;
  case AST_Decl::NT_sequence:
    be_sequence *bseq;
    bseq = be_sequence::narrow_from_decl(type);
    if (bseq == NULL) {
      cout << "Error in narrowing from type do sequence\n";
      BE_abort();
    }
    else {
      char typename[255], digits[6];
      be_expr_val expr(bseq->max_size(), bseq->max_size()->ev()->et);

      expr.value_only_2string_ctranslation(digits);
      translate_typename_for_pure_name(bseq->base_type(), typename);
      idl_global->indent()->skip_to(o);
      o << left_side << "._length  = " << right_side << "._length;\n";
      idl_global->indent()->skip_to(o);
      /* the following statement generates cheking of buffer allocation,*/
      /* ie, if there is enough buffer to perform the assignment */ 
      o << "if (" << left_side << "._maximum < " << right_side
	<< "._maximum) {\n";
      idl_global->indent()->increase();
      idl_global->indent()->skip_to(o);
      o << "if (" << left_side << "._buffer != NULL)\n";
      idl_global->indent()->increase();
      idl_global->indent()->skip_to(o);
      o << "CORBA_free(" << left_side << "._buffer);\n";
      idl_global->indent()->decrease();
      idl_global->indent()->skip_to(o);
      o << left_side << "._buffer = (" << typename << "*) CORBA_alloc(\n";
      idl_global->indent()->skip_to(o);
      o << "    sizeof(" << typename << ") *" 
	<< right_side << "._maximum);\n";
      idl_global->indent()->decrease();
      idl_global->indent()->skip_to(o);
      o << "}\n";
      idl_global->indent()->skip_to(o);
      o << "if (" << right_side << "._buffer != NULL)\n";
      idl_global->indent()->increase();
      idl_global->indent()->skip_to(o);
      o << "bcopy ((char *) " << right_side
	<< "._buffer, (char *) " << left_side 
	<< "._buffer, " << right_side << "._length * sizeof("
	<< typename << "));\n";
      idl_global->indent()->decrease();
      idl_global->indent()->skip_to(o);
      o << left_side << "._maximum = " << right_side << "._maximum;\n";
    }
    break;
  default: 
    cout << "In generate_assignment for "
	 << left_side << "=" << right_side << ": type unexpected \n"
	 << "(node_type() is " << type->node_type() << ")\n";
    BE_abort();
  } /* end of switch */

}


/*
 * generate_return (a, type, out)
 *
 * This routine outputs in "out" the code for "return(a)". Notice
 * that how this is accomplished depends on the specific type.
 * For basic types such as CORBA_char,  CORBA_long, we can do
 * just "return(a)", but for strings, sequences, arrays, etc, type
 * specific memory allocations have to be done.
 */

void
generate_return (char *returnvalue, AST_Type *type, ostream &o)
{ 
  switch (type->node_type()) {
  case AST_Decl::NT_typedef:
    AST_Typedef *def;
    def = AST_Typedef::narrow_from_decl(type);
    if (def == NULL) {
      cout << "Narrowing failed in generate_return\n";
      BE_abort();
    }
    else
     generate_return(returnvalue, def->base_type(),o);
    break;
  case AST_Decl::NT_enum:
  case AST_Decl::NT_pre_defined:
  case AST_Decl::NT_struct:
    idl_global->indent()->skip_to(o);
    o << "return(" << returnvalue << ");\n";
    break;
  case AST_Decl::NT_string:
  case AST_Decl::NT_array:
    cout << "generate_assignemnt: implementation for"
	 << "string, array not done yet\n";
    BE_abort();
    break;
  case AST_Decl::NT_sequence:
    be_sequence *bseq;
    bseq = be_sequence::narrow_from_decl(type);
    if (bseq == NULL) {
      cout << "Error in narrowing from type do sequence\n";
      BE_abort();
    }
    else {
      char typename[255], digits[6];
      be_expr_val expr(bseq->max_size(), bseq->max_size()->ev()->et);

      expr.value_only_2string_ctranslation(digits);
      translate_typename_for_pure_name(bseq->base_type(), typename);
      idl_global->indent()->skip_to(o);
      o << "CORBA_sequence_" << typename << "_" << digits << " seq;\n";
      idl_global->indent()->skip_to(o);
      o << "seq._maximum = " << returnvalue << "._maximum;\n";
      idl_global->indent()->skip_to(o);
      o << "seq._length  = " << returnvalue << "._length;\n";
      idl_global->indent()->skip_to(o);
      o << "seq._buffer  = (" << typename << "*) CORBA_alloc (" 
	<< returnvalue << "._maximum*sizeof(" << typename << "));\n";
      idl_global->indent()->skip_to(o);
      o << "if (seq._buffer == NULL) {\n";
      idl_global->indent()->increase();
      idl_global->indent()->skip_to(o);
      o << "printf(\"No memory for returning sequence\\n\");\n";
      idl_global->indent()->skip_to(o);
      o	<< "exit(1);\n";
      idl_global->indent()->decrease();
      idl_global->indent()->skip_to(o);
      o	<< "}\n";
      idl_global->indent()->skip_to(o);
      o << "bcopy ((char *) " << returnvalue 
	<< "._buffer, (char *) seq._buffer, seq._length * sizeof("
	<< typename << "));\n";
      idl_global->indent()->skip_to(o);
      o << "return (seq);\n";
    }
    break;
  default: 
    cout << "In generate_return for "
	 << returnvalue << ": type unexpected \n"
	 << "(node_type() is " << type->node_type() << ")\n";
    BE_abort();
  } /* end of switch */

}


