/*
 * IDLtoC.h
 *
 * This file contains definitions for basic CORBA types
 */

#ifndef IDLtoC_H
#define IDLtoC_H

#include <malloc.h>
 
#define NULL 0

/* Definition of basic types */
#define CORBA_short               short
#define CORBA_unsigned_short      unsigned short
#define CORBA_long                long
#define CORBA_unsigned_long       unsigned long
#define CORBA_float               float
#define CORBA_double              double
#define CORBA_boolean             char
#define CORBA_char                char
#define CORBA_octet               int
#define CORBA_enum                long

/* 
typedef short              CORBA_short;
typedef unsigned short     CORBA_unsigned_short;
typedef long               CORBA_long;
typedef unsigned long      CORBA_unsigned_long;
typedef float              CORBA_float;
typedef double             CORBA_double;
typedef char               CORBA_boolean;
typedef char               CORBA_char;
typedef int                CORBA_octet;
typedef long               CORBA_enum;

*/

#define CORBA_void   void
#define CORBA_alloc  malloc
#define CORBA_free   free

/* Definition of CORBA_object */
typedef void *any_t;

typedef struct {
  any_t attrib_struct;
  any_t state;
} *CORBA_Object, CORBA_Object_struct;

typedef struct {
  char nothing;          /* for now we don't have anything ... */
} CORBA_Environment;
#endif
