/*
 * Copyright (c) 1996 Edward Kluk. All Rights Reserved.
 * E-mail address: ed_kluk@dsu1.dsu.nodak.edu
 * This software was written by myself in my private time on my own 
 * computer installed home.
 *
 * For NON-COMMERCIAL purposes you can use and modyfy this software free
 * provided that you obey the following rules: 
 * 	1. This copyright notice with all rules appears in all copies.
 *	2. You EXPECT NO WARRANTIES related to use of this software in its
 *	original or modified form.
 *	3. If it is modified full information who and when have made this
 *	modification must be provided below this copy right notice.  
 * 	4. If it is modified all users of modified version must have access
 *	via Internet to the code sources of original and modified versions.
 */



import java.applet.*;
import java.awt.*;
import java.util.*;

public class m_psforces extends Applet implements Runnable 
{

	Graphics		g;
	Graphics		osg;
	Image			osImage;
	Dimension		dimension;

	Color			color_ft = new Color(0,0,255);
	Color			color_bg = new Color(255,255,255);
	Color			color_ob = new Color(255,0,0);


	Button		start_b, reset_b, clear_b, stop_b, go_b;
	Choice		orbit_rad_cho, period_numb_cho;
	Choice		path_cho, planet_rot_cho;
	Label			copy_right;
	int			j = 0, k = 0, l = 0, m = 0;

	String		x_sat_str = "0", y_sat_str = "1";
	String		x_mark_str = "0", y_mark_str = "0";
	String		path_cho_str;
	String		orbit_rad_str = "0.30", period_numb_cho_str = "1";
	String		t_start_str, t_curr_str;
	String		t_str = "", d_str = "";
	String		h_str = "";
	String		orbit_rad_cho_str = "0.30", planet_rot_cho_str = "0.010";
	String		y_0_str;

	long			t_start_long, t_curr_long, t_pass_long;
	double		t_pass_double = 0;
	double		pi_double = 2*Math.asin(1);
	double		omega_sat_double = 0.1, omega_0_sat_double = 0.1;
	double		omega_plan_double = 0.10;
	double		orbit_rad_double = 0.30, planet_rot_double = 0.010;
	double		x_sat_double = 0, y_sat_double = 1;
	double		angle_sat_double = 0, angle_mark_double;
	double		x_mark_double = 0, y_mark_double = 0;

	int			period_numb_int = 1;
	int			x_sat_int = 166, y_sat_int = 83;
	int			x_0_sat_int = 166, y_0_sat_int = 83;
	int			y_0_int;
	int			x_mark_int = 0, y_mark_int = 0;
	int			x_0_mark_int = 167, y_0_mark_int = 149;
	int			x_arrow = 166, y_arrow = 2;

	int			flag_run = 0;

	Font			font = new Font("Helvetica", 1, 12);

	Thread		thr_tc = null;


    protected void makelabel(String text,
                              GridBagLayout gridbag,
                              GridBagConstraints c) {
        Label label = new Label(text);
        gridbag.setConstraints(label, c);
        add(label);
    }

	public void init()
	{

        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
 
        setFont(new Font("Helvetica", Font.PLAIN, 14));
        setLayout(gridbag);

	  c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;  
	  c.anchor = GridBagConstraints.NORTHWEST;

	  c.gridwidth = 1;
	  for (m = 0; m <= 13; m++) {
		  makelabel("   ", gridbag,c);
	  }
	  c.gridwidth = GridBagConstraints.REMAINDER; //end of row
	  makelabel("", gridbag,c);
/*	This section creates a column structure (15 columns). A column width is decided by
	a longest element in this column. Only two of these 15 columns are needed to place 
	controls. The rest of them are filled with empty strings. It saves space for other 
	panel elements. The statement c.weightx = 1.0 spreds columns over the whole width of 
	the panel. 
*/

	  c.anchor = GridBagConstraints.NORTHWEST;

	  c.gridwidth = 2;
	  makelabel(" orbit radius (Gm) ", gridbag,c);
	  c.gridwidth = GridBagConstraints.REMAINDER; //end of row

		orbit_rad_cho = new Choice ();
		orbit_rad_cho.addItem ("0.15");
		orbit_rad_cho.addItem ("0.20");
		orbit_rad_cho.addItem ("0.25");
		orbit_rad_cho.addItem ("0.30");
		orbit_rad_cho.addItem ("0.35");
		orbit_rad_cho.addItem ("0.40");
		orbit_rad_cho.addItem ("0.45");

		orbit_rad_cho.select ("0.30");
    		gridbag.setConstraints(orbit_rad_cho, c);
		add (orbit_rad_cho);

	  c.gridwidth = 2;
	  makelabel(" # of periods ", gridbag,c);
	  c.gridwidth = GridBagConstraints.REMAINDER; //end of row

		period_numb_cho = new Choice ();
		period_numb_cho.addItem ("1");
		period_numb_cho.addItem ("2");
		period_numb_cho.addItem ("3");
		period_numb_cho.addItem ("4");
		period_numb_cho.addItem ("5");
		period_numb_cho.addItem ("6");
		period_numb_cho.addItem ("7");
		period_numb_cho.addItem ("8");
		period_numb_cho.addItem ("9");
		period_numb_cho.addItem ("10");
		period_numb_cho.select ("1");
      	gridbag.setConstraints(period_numb_cho, c);
      	add(period_numb_cho);


	  c.gridwidth = 2;
	  makelabel(" path tracer ", gridbag,c);
	  c.gridwidth = GridBagConstraints.REMAINDER; //end of row

		path_cho = new Choice ();
		path_cho.addItem ("off");
		path_cho.addItem ("on");
		path_cho.select ("off");
    		gridbag.setConstraints(path_cho, c);
		add (path_cho);

	  c.gridwidth = 2;
	  makelabel(" planet rot. (rad/Ks) ", gridbag,c);
	  c.gridwidth = GridBagConstraints.REMAINDER; //end of row

		planet_rot_cho = new Choice ();
		planet_rot_cho.addItem ("0.000");
		planet_rot_cho.addItem ("0.005");
		planet_rot_cho.addItem ("0.010");
		planet_rot_cho.addItem ("0.015");
		planet_rot_cho.addItem ("0.020");
		planet_rot_cho.addItem ("0.025");
		planet_rot_cho.addItem ("0.030");

		planet_rot_cho.select ("0.010");
    		gridbag.setConstraints(planet_rot_cho, c);
		add (planet_rot_cho);


	  c.gridwidth = 2;
	  for (m = 0; m <= 0; m++) {
		  c.gridwidth = GridBagConstraints.REMAINDER;
		  makelabel("", gridbag,c);
	  } 
/*	This segment creates one empty row in the panel. Related to it statement 
	c.weighty = 1.0 causes uniform distribution of rows in the panel. Setting
	m <= 2 would create three empty rows.
*/
	  c.gridwidth = 2;
	  makelabel("", gridbag,c);
        c.gridwidth = GridBagConstraints.REMAINDER;
        go_b = new Button("  go  ");
        gridbag.setConstraints(go_b, c);
        add(go_b);

	  c.gridwidth = 2;
	  makelabel("", gridbag,c);
        c.gridwidth = GridBagConstraints.REMAINDER;
        clear_b = new Button("clear");
        gridbag.setConstraints(clear_b, c);
        add(clear_b);

	  c.gridwidth = 2;
	  makelabel("", gridbag,c);
        c.gridwidth = GridBagConstraints.REMAINDER;
        reset_b = new Button("reset");
        gridbag.setConstraints(reset_b, c);
        add(reset_b);

	  c.gridwidth = 2;
	  makelabel("", gridbag,c);
        c.gridwidth = GridBagConstraints.REMAINDER;
        start_b = new Button("start ");
        gridbag.setConstraints(start_b, c);
        add(start_b);

	  c.gridwidth = 2;
	  makelabel("", gridbag,c);
        c.gridwidth = GridBagConstraints.REMAINDER; 
		stop_b = new Button ("stop ");
        gridbag.setConstraints(stop_b, c);
        add(stop_b);

	  c.gridwidth = GridBagConstraints.REMAINDER;
	  makelabel(" Copyright\u00a9EK ", gridbag,c);

			input_disable();
			start_b.disable();
			stop_b.disable();
			go_b.disable();
			clear_b.enable();
			clear_b.requestFocus();
	 		reset_b.disable();

		g = getGraphics ();
		osImage = createImage(340,340);
	}

	public void os_paint (Graphics g)
	{
		if(flag_run == 1) {
		osg.setColor(color_bg);
		osg.fillRect(0,0,340,340);

		osg.setColor(color_ob);
		osg.fillRect(166,83,4,4);


		osg.setColor(color_ft);
		osg.drawString("toward a distant star",175,16);
		x_arrow = 166;
		y_arrow = 2;
		arrow(x_arrow,y_arrow);
		osg.fillRect(0,325,340,1);
		osg.fillRect(318,0,1,325);
		osg.drawString("m",3,338);
		osg.drawString("G",3,320);
		for (j = 0; j <= 10; j++)
		{
		osg.fillRect(18 + 30*j,325,1,14);
		if(j != 10){
			osg.drawString("." + Integer.toString(j),22 + 30*j,338);
		}
		else{
			osg.drawString("1",22 + 30*j,338);
		}
		osg.fillRect(318,25 + 30*j,18,1);
		if(j != 0){
			osg.drawString("." + Integer.toString(10 - j),321,23 + 30*j);
		}
		else{
			osg.drawString("1",321,23 + 30*j);
		}		
		}

		osg.fillOval(138,145,60,60);
		osg.setColor(color_bg);
		osg.fillRect(167,149,2,2);

			flag_run = 2;
		}

		if(flag_run == 4) {
			osg.setColor(color_ft);
			osg.fillRect(x_0_mark_int,y_0_mark_int,2,2);
			osg.setColor(color_bg);
			osg.fillRect(x_mark_int,y_mark_int,2,2);
			if (path_cho_str == "on") {osg.setColor(color_ob);}
			osg.fillRect(x_0_sat_int,y_0_sat_int,4,4);
			osg.setColor(color_ob);
			osg.fillRect(x_sat_int,y_sat_int,4,4);
			x_0_sat_int = x_sat_int;
			y_0_sat_int = y_sat_int;
			x_0_mark_int = x_mark_int;
			y_0_mark_int = y_mark_int;

		}


		if(flag_run == 5){
			osg.setColor(color_ft);
			osg.fillRect(x_0_mark_int,y_0_mark_int,2,2);
			osg.setColor(color_bg);
			osg.fillRect(167,149,2,2);
			osg.fillRect(166,83,4,4);
			if (path_cho_str == "on" && x_0_sat_int != 166) {
				osg.setColor(color_ob);
			}
			osg.fillRect(x_0_sat_int,y_0_sat_int,4,4);

			y_0_str = Double.toString(Math.rint((10*orbit_rad_double - 3)*30));

			if(y_0_str.endsWith(".0"))
			y_0_str = y_0_str.substring(0,y_0_str.length()-2);

			y_0_int = 83 - Integer.parseInt(y_0_str);
			y_sat_int = y_0_int; 

			osg.setColor(color_ob);
			osg.fillRect(166,y_sat_int,4,4);

			x_0_sat_int = 166;
			y_0_sat_int = y_sat_int;
			t_start_long = 0;
			reset_b.disable();
			orbit_rad_cho.enable();
			planet_rot_cho.enable();
			period_numb_cho.enable();
			path_cho.enable();
			clear_b.enable();
			start_b.enable();
			clear_b.requestFocus();
		
			flag_run = 2;
		}
	}

	public void paint(Graphics g)
	{
		os_paint(osg);
		g.drawImage(osImage,250,30,null);
	}


	public void update(Graphics g)
	{
		osg = osImage.getGraphics();
		paint(g);
	}

	public void time_count()
	{
		if (flag_run == 3) {
			flag_run = 4;
			y_0_str = Double.toString(Math.rint((10*orbit_rad_double - 3)*30));

			if(y_0_str.endsWith(".0"))
			y_0_str = y_0_str.substring(0,y_0_str.length()-2);

			y_0_int = 83 - Integer.parseInt(y_0_str);
			omega_sat_double = omega_0_sat_double/Math.sqrt(Math.pow(10*orbit_rad_double/3,3));
			omega_plan_double = 100*planet_rot_double*omega_0_sat_double;
			t_start_long = System.currentTimeMillis();
		}

		t_curr_long = System.currentTimeMillis();
		t_pass_long = t_curr_long - t_start_long;
		t_str = Long.toString(t_pass_long);
		t_pass_double = Double.valueOf(t_str).doubleValue();

		angle_sat_double = omega_sat_double*t_pass_double/1000;
		x_sat_double = 300*orbit_rad_double*Math.sin(angle_sat_double);
		y_sat_double = 300*orbit_rad_double*(1 - Math.cos(angle_sat_double));
		x_sat_str = Double.toString(Math.rint(x_sat_double));
		y_sat_str = Double.toString(Math.rint(y_sat_double));

		if(x_sat_str.endsWith(".0"))
		x_sat_str = x_sat_str.substring(0,x_sat_str.length()-2);
		if(y_sat_str.endsWith(".0"))
		y_sat_str = y_sat_str.substring(0,y_sat_str.length()-2);

		x_sat_int = 166 - Integer.parseInt(x_sat_str);
		y_sat_int = y_0_int + Integer.parseInt(y_sat_str);

		angle_mark_double = omega_plan_double*t_pass_double/1000;
		x_mark_double = 25*Math.sin(angle_mark_double);
		y_mark_double = 25*(1 - Math.cos(angle_mark_double));
		x_mark_str = Double.toString(Math.rint(x_mark_double));
		y_mark_str = Double.toString(Math.rint(y_mark_double));

		if(x_mark_str.endsWith(".0"))
		x_mark_str = x_mark_str.substring(0,x_mark_str.length()-2);
		if(y_mark_str.endsWith(".0"))
		y_mark_str = y_mark_str.substring(0,y_mark_str.length()-2);

		x_mark_int = 167 - Integer.parseInt(x_mark_str);
		y_mark_int = 149 + Integer.parseInt(y_mark_str);

			
		if(angle_sat_double > 2*period_numb_int*pi_double) {
			flag_run = 0;
			input_disable();
			start_b.disable();
			stop_b.disable();
			clear_b.disable();
			reset_b.enable();
			reset_b.requestFocus();
		}		
	}

	public void start()
	{
		thr_tc = new Thread(this);
		thr_tc.start();
	}

	public void run()
	{
		try {Thread.sleep(100);}catch(InterruptedException e){}
		if(flag_run == 1){
			repaint();
		}
		if(flag_run == 3){
			time_count();
			repaint();
			flag_run = 4;
		}
		if(flag_run == 4){
			time_count();
			repaint();
		}
		if(flag_run == 5){
			repaint();
		}

		run();
	}

	public void stop(){
		if(thr_tc != null){
			thr_tc.stop();
			thr_tc = null;
		}
 	}

	public boolean action (Event e, Object o)
	{
		if (e.target == start_b) {
			flag_run = 3;
			stop_b.enable();
			stop_b.requestFocus();
			start_b.disable();
			reset_b.disable();
			clear_b.disable();
			input_disable();
		}

		if (e.target == stop_b) {
			flag_run = 0;
			clear_b.disable();
			reset_b.enable();
			reset_b.requestFocus();
			stop_b.disable();
			input_disable();
		}

		if (e.target == reset_b) {
			flag_run = 5;
			start_b.disable();
			reset_b.disable();
			stop_b.disable();
		      clear_b.enable();
		      start_b.enable();
			start_b.requestFocus();
		}
		if (e.target == clear_b) {
			flag_run = 1;
			stop_b.disable();
			clear_b.disable();
			go_b.disable();

			orbit_rad_cho.select ("0.30");
			planet_rot_cho.select ("0.010");
			period_numb_cho.select ("1");
			path_cho.select ("off");

			orbit_rad_double = 0.30;
			planet_rot_double = 0.010;
			period_numb_int = 1;
			path_cho_str = path_cho.getSelectedItem();

			orbit_rad_cho_str = orbit_rad_cho.getSelectedItem();
			orbit_rad_double = Double.valueOf(orbit_rad_cho_str).doubleValue();
			planet_rot_cho_str = planet_rot_cho.getSelectedItem();
			planet_rot_double = Double.valueOf(planet_rot_cho_str).doubleValue();

			orbit_rad_cho.enable();
			planet_rot_cho.enable();
			planet_rot_cho.enable();
			period_numb_cho.enable();
			path_cho.enable();
			start_b.enable();
			start_b.requestFocus();
		}
		if (e.target == go_b) {
			flag_run = 5;
			stop_b.disable();
			go_b.disable();
			reset_b.disable();
		      start_b.enable();
			start_b.requestFocus();
			clear_b.enable();
			start_b.requestFocus();
		}

		if (e.target == orbit_rad_cho)
		{
		      clear_b.disable();
			start_b.disable();

			orbit_rad_cho_str = orbit_rad_cho.getSelectedItem();
			orbit_rad_double = Double.valueOf(orbit_rad_cho_str).doubleValue();

			go_b.enable();
			go_b.requestFocus();
			stop_b.disable();
	 		reset_b.disable();
		}

		if (e.target == planet_rot_cho)
		{
		      clear_b.disable();
			start_b.disable();

			planet_rot_cho_str = planet_rot_cho.getSelectedItem();
			planet_rot_double = Double.valueOf(planet_rot_cho_str).doubleValue();

			go_b.enable();
			go_b.requestFocus();
			stop_b.disable();
	 		reset_b.disable();
		}

		if (e.target == period_numb_cho)
		{
		      clear_b.disable();
			start_b.disable();

			period_numb_cho_str = period_numb_cho.getSelectedItem();
			period_numb_int = Integer.valueOf(period_numb_cho_str).intValue();

			go_b.enable();
			go_b.requestFocus();
			stop_b.disable();
	 		reset_b.disable();
		}


		if (e.target == path_cho)
		{
		      clear_b.disable();
			start_b.disable();

			path_cho_str = path_cho.getSelectedItem();

			go_b.enable();
			go_b.requestFocus();
			stop_b.disable();
	 		reset_b.disable();
		}

            return true;
	}

	public void input_disable()
	{
		orbit_rad_cho.disable();
		planet_rot_cho.disable();
		period_numb_cho.disable();
		path_cho.disable();
	}

	public void arrow(int x_arrow, int	y_arrow)
	{
		osg.fillRect(x_arrow,y_arrow,1,1);
		osg.fillRect(x_arrow - 1,y_arrow + 1,3,1);
		osg.fillRect(x_arrow - 2,y_arrow + 2,5,1);
		osg.fillRect(x_arrow - 3,y_arrow + 3,7,1);
		osg.fillRect(x_arrow - 1,y_arrow + 4,3,10);
	}
/*	public boolean handleEvent(Event e)
	{
		if(e.id == Event.WINDOW_DESTROY) {
			hide();		//hides frame
			dispose();		//frees resources
			return true;
		}

		return super.handleEvent(e);
	}
*/
}