package uce.parser;

import java.util.Hashtable;
import org.antlr.runtime.RecognitionException;

/**
 *
 * @author chepa
 */
public class ExtendedRecognitionException extends RecognitionException {

    private RecognitionException inner;
    private Hashtable<String, String> hmpExceptions;

    public ExtendedRecognitionException(RecognitionException ex) {
        this.inner = ex;
        hmpExceptions = new Hashtable<String, String>();
    }

    public void add(String key, String value) {
        hmpExceptions.put(key, value);
    }

    public void append(String key, String value) {
        hmpExceptions.put(key, hmpExceptions.get(key) + value);
    }

    public boolean contains(String key) {
        return hmpExceptions.containsKey(key);
    }

    public String getExceptionData(String key) {
        return hmpExceptions.get(key);
    }

    public RecognitionException getRecognitionException() {
        return inner;
    }
}
