/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package uce.parser;

import dict.IDictionary;
import dict.WNDictionary;
import dowser.model.DomainModel;
import dowser.model.Relation;
import dowser.ui.StaticModelUI;
import edu.smu.tspell.wordnet.SynsetType;
import java.util.Collection;
import javax.swing.JOptionPane;
import ontology.ui.OntologyUI;
import usecase.OntoPhrase;
import usecase.Quantifier;
import usecase.Statement;
import usecase.StatementText.ObjectPhrase;
import usecase.UseCase;

/**
 *
 * @author Chetan Pawgi
 */
public final class DynamicModelValidator {

	private static IDictionary dictionary = WNDictionary.getInstance();

	private static boolean isValidWord(String word) {
		Collection<String> arrSyns = dictionary.getSynonyms(word);
		return !(arrSyns == null || arrSyns.size() == 0);
	}

	private static boolean isValidNoun(String word) {
		Collection<String> arrSyns = dictionary.getSynonyms(word, SynsetType.NOUN);
		return !(arrSyns == null || arrSyns.size() == 0);
	}

	public static boolean ValidateModel(UseCase useCase) {
		boolean bValid = true;
		for (Statement stmt : useCase.getNormalCourse().getStatement()) {
			bValid &= processStatement(stmt);
		}
		return bValid;
	}

	private static boolean isValidAction(dowser.model.Class cClass, String action) {
		if (cClass.containsOperation(action)) {
			return true;
		}
		for (dowser.model.Class superClass : cClass.getSuperClasses()) {
			if (isValidAction(superClass, action)) {
				return true;
			}
		}
		for (Relation r : cClass.getRelations()) {
			if (r.getName().equals(action)) {
				return true;
			}
		}
		return false;
	}

	private static boolean processStatement(Statement statement) {
		boolean bValid = true;
		DomainModel combinedModel = DomainModel.getMergedModel(StaticModelUI.getInstance().getStaticModel(), OntologyUI.getInstance().getOntologyModel());
		if (statement == null) {
			throw new IllegalArgumentException("statement can't be null IN internalProcessStatement");
		}
		String actor = statement.getText().getActor();
		if (!combinedModel.containsClass(actor)) {
			JOptionPane.showMessageDialog(null, "Actor " + actor + " is not present in either ontology or the static model !");
			bValid = false;
		}
		String action = statement.getText().getAction();
		ObjectPhrase objPhrase = statement.getText().getObjectPhrase();
		String rootAction = dictionary.getRootVerb(action);
		if (rootAction != null) {
			action = rootAction;
		}
		if (rootAction == null && !bValid) {
			JOptionPane.showMessageDialog(null, "Action " + action + " is not a valid verb !");
		}
		if (bValid) {
			boolean bValidAction = false;
			if (objPhrase != null) {
				if (objPhrase.getOntoPhrase() != null) {
					OntoPhrase ontPhrase = objPhrase.getOntoPhrase();
					if (ontPhrase.getConcept() != null && combinedModel.containsClass(ontPhrase.getConcept())) {
						dowser.model.Class objClass = combinedModel.getClass(ontPhrase.getConcept());
						if (isValidAction(objClass, action)) {
							bValidAction = true;
						}
					} else if (ontPhrase.getAttribConcept() != null && combinedModel.containsClass(ontPhrase.getAttribConcept().getConcept())) {
						dowser.model.Class objClass = combinedModel.getClass(ontPhrase.getAttribConcept().getConcept());
						if (isValidAction(objClass, action)) {
							bValidAction = true;
						} else if (combinedModel.containsClass(ontPhrase.getAttribConcept().getAttribute())) {
							dowser.model.Class objAttribClass = combinedModel.getClass(ontPhrase.getAttribConcept().getAttribute());
							if (isValidAction(objAttribClass, action)) {
								bValidAction = true;
							}
						}
					}
				}
			}
			if (objPhrase == null || !bValidAction) {
				dowser.model.Class cActor = combinedModel.getClass(actor);
				if (!bValidAction && rootAction != null && !isValidAction(cActor, rootAction) && !isValidAction(cActor, action)) {
					JOptionPane.showMessageDialog(null, "Action " + action + " is not a valid operation !");
				} else {
					bValidAction = true;
				}
			}
			bValid &= bValidAction;
		}
		return bValid;
	}
//		Extension ext = statement.getText().getExtension();
//		String extCond = "";
//		if (ext != null) {
//			if (ext.getUntil() != null) {
//				extCond = "UNTIL ";
//				for (Condition cond : ext.getUntil().getCondition()) {
//					OntValueCondition ontVal = cond.getOntValueCondition();
//					if (ontVal != null) {
//						OntoPhrase Lphrase = ontVal.getLvalue();
//						if (ontVal.getRelation() != ValueRelation.BY && ontVal.getRelation() != ValueRelation.TO) {
//							String lVal = "";
//							if (Lphrase.getAttribConcept() != null) {
//								lVal = Lphrase.getAttribConcept().getAttribute() + " of " + Lphrase.getAttribConcept().getConcept();
//							} else {
//								lVal = Lphrase.getConcept();
//							}
//							extCond += lVal;
//							extCond += " " + ontVal.getRelation().toString() + " ";
//							extCond += ontVal.getRvalue();
//						}
//					}
//				}
//			} else if (ext.getFor() != null) {
//				extCond = "FOR " + ext.getFor().getQuantity() + " " + ext.getFor().getUnitOftime();
//			}
//			if (!extCond.isEmpty()) {
//				extCond = "[ " + extCond + " ]";
//			}
//		}

	private DynamicModelValidator() {
	}

	public static String getObjectOfAction(OntoPhrase ontoPhrase) {
		if (ontoPhrase == null) {
			throw new IllegalArgumentException("ontoPhrase can't be null IN getObjectOfAction(OntoPhrase)");




		}
		OntoPhrase.AttribConcept attribConcept = ontoPhrase.getAttribConcept();




		if (attribConcept != null) {
			return attribConcept.getAttribute() + "_OF_" + attribConcept.getConcept();




		}
		return ontoPhrase.getConcept();




	}

	public static String getObjectOfAction(ObjectPhrase objPhrase) {
		if (objPhrase == null) {
			throw new IllegalArgumentException("objPhrase can't be null IN getObjectOfAction(ObjectPhrase)");




		}
		OntoPhrase ontoPhrase = objPhrase.getOntoPhrase();




		if (ontoPhrase != null) {
			return getObjectOfAction(ontoPhrase);




		}
		return getObjectOfAction(objPhrase.getOntValueCondition().getLvalue());




	}

	public static Quantifier getObjectQuantifier(ObjectPhrase objPhrase) {
		if (objPhrase == null) {
			throw new IllegalArgumentException("objPhrase can't be null IN getObjectOfAction(ObjectPhrase)");




		}
		OntoPhrase ontoPhrase = objPhrase.getOntoPhrase();




		if (ontoPhrase != null) {
			return ontoPhrase.getQuantifier();




		}
		return objPhrase.getOntValueCondition().getLvalue().getQuantifier();


	}
}
