/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package dowser.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;

/**
 *
 * @author Chetan Pawgi
 */
public class ImagePanel extends JPanel {

	private BufferedImage image;
	private int m_inSet = 20;

	public void setImageFile(File file) {
		try {
			image = ImageIO.read(file);
			m_inSet = (int) ((double) getWidth() / 20.0F);
			Dimension dimension = new Dimension(image.getWidth() + m_inSet * 2, image.getHeight() + m_inSet * 2);
			this.setPreferredSize(dimension);
			this.setMinimumSize(dimension);
			this.setMaximumSize(dimension);
			this.setSize(dimension);
		} catch (IOException ex) {
			ex.printStackTrace(System.err);
		}
	}

	@Override
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		if (image != null) {
			g.drawImage(image, m_inSet, m_inSet, Color.WHITE, null);
		}
	}
}
