package dowser.model;

import java.util.Collections;
import java.util.List;
import java.util.Vector;

/**
 *
 * @author Chetan Pawgi
 */
public class Relation extends DomainEntity {

	public static class Participant extends DomainEntity {

		private Class m_class;
		private Relation m_relation;
		private String m_role;
		private String m_multiplicity;

		public String getMultiplicity() {
			return m_multiplicity;
		}

		public void setMultiplicity(String mul) {
			if (mul.contains("..")) {
				String[] arr = mul.split("[.][.]");
				if (arr.length != 2) {
					throw new IllegalArgumentException("Multiplicity can't be " + mul);
				}
				int[] nm = new int[2];
				int i = 0;
				for (String s : arr) {
					try {
						nm[i] = Integer.parseInt(s);
						i++;
					} catch (NumberFormatException ex) {
						if (s.equals("*")) {
							nm[i] = Integer.MAX_VALUE;
						} else {
							throw new IllegalArgumentException("Multiplicity can't be " + mul);
						}
					}
				}
				if (nm[0] > nm[1]) {
					throw new IllegalArgumentException("Multiplicity can't be " + mul);
				}

			} else {
				try {
					Integer.parseInt(mul);
				} catch (NumberFormatException ex) {
					throw new IllegalArgumentException("Multiplicity can't be " + mul);
				}
			}
			m_multiplicity = mul;
		}

		public Class getParticipatingClass() {
			return m_class;
		}

		public void setParticipatingClass(Class cClass) {
			m_class = cClass;
		}

		public Relation getRelation() {
			return m_relation;
		}

		public String getRole() {
			return m_role;
		}

		public void setRole(String role) {
			m_role = role;
		}

		private Participant(String name, Relation relation, Class m_class, String role, String multiplicity) {
			super(name);
			this.m_class = m_class;
			this.m_relation = relation;
			this.m_role = role;
			setMultiplicity(multiplicity);
		}
	}
	private List<Participant> participants;

	public List<Participant> getParticipants() {
		return Collections.unmodifiableList(participants);
	}

	public Participant getParticipant(int index) {
		return participants.get(index);
	}

	public int getParticipantCount() {
		return participants.size();
	}

	public void addParticipant(Class c, String role, String multiplicity) {
		participants.add(new Participant(c.getName() + "_as_" + role, this, c, role, multiplicity));
		c.addRelation(this);
	}

	{
		participants = new Vector<Participant>();
	}

	public Relation(String name) {
		super(name);
	}

	@Override
	public int hashCode() {
		return 1;

	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Relation) {
			if (obj == this) {
				return true;
			}
			return false;
		}
		return super.equals(obj);
	}

	@Override
	public String toString() {
		StringBuilder bld = new StringBuilder();
		bld.append("Relation : " + getName() + "\n");
		for (Participant p : participants) {
			bld.append("Participant : " + p.getParticipatingClass().getName() + ", Role : " + p.getRole() + ", Multiplicity : " + p.getMultiplicity() + "\n");
		}
		return bld.toString();
	}
}
