package dowser.model;

/**
 *
 * @author Chetan Pawgi
 */
public class Operation extends DomainEntity {

	private Class m_parent;

	public Operation(Class cClass, String name) {
		super(name);
		m_parent = cClass;
	}

	public Class getParentClass() {
		return m_parent;
	}

	@Override
	public int hashCode() {
		return (super.hashCode() + "" + getParentClass().hashCode()).hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Operation) {
			return ((Operation) obj).getParentClass().equals(this.getParentClass()) && super.equals(obj);
		}
		return super.equals(obj);
	}
}
