package dowser.model;

/**
 *
 * @author Chetan Pawgi
 */
abstract public class DomainEntity {

	protected String m_name;

	public String getName() {
		return m_name;
	}

	void setName(String name) {
		m_name = name;
	}

	@Override
	public String toString() {
		return m_name;
	}

	@Override
	public int hashCode() {
		return m_name.hashCode();
	}

	public DomainEntity(String name) {
		m_name = name;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		final DomainEntity other = (DomainEntity) obj;
		if ((this.m_name == null) ? (other.m_name != null) : !this.m_name.equals(other.m_name)) {
			return false;
		}
		return true;
	}
}
