package dowser.model;

/**
 *
 * @author Chetan Pawgi
 */
public class Attribute extends DomainEntity {

	private Class m_type;
	private Class m_parent;

	public Attribute(Class cClass, String name) {
		super(name);
		m_parent = cClass;
	}

	public Attribute(Class cClass, String name, Class type) {
		this(cClass, name);
		this.m_type = type;
	}

	public Class getType() {
		return m_type;
	}

	public Class getParentClass() {
		return m_parent;
	}

	@Override
	public int hashCode() {
		return (super.hashCode() + "" + getParentClass().hashCode()).hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Attribute) {
			return ((Attribute) obj).getParentClass().equals(this.getParentClass()) && super.equals(obj);
		}
		return super.equals(obj);
	}
}
