/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package dowser;

import dowser.model.DomainEntity;
import dowser.model.DomainModel;
import dowser.model.Relation;
import dowser.ui.DomainTreeModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 *
 * @author Chetan Pawgi
 */
public final class Util {

	public static String convertDomainRepresentation(Object value) {
		if (value instanceof DomainModel) {
			value = "Static Model";
		} else if (value instanceof Relation.Participant) {
			Relation.Participant participant = (Relation.Participant) value;
			value = String.format("%s (as %s) (%s)", participant.getParticipatingClass().getName(), participant.getRole(), participant.getMultiplicity());
		} else if (value instanceof DomainEntity) {
			value = ((DomainEntity) value).getName();
		} else if (value instanceof DomainTreeModel.Node) {
			return ((DomainTreeModel.Node) value).getText();
		}
		return value.toString();
	}

	public static List removeDuplicatesWithOrder(List list) {
		Set set = new HashSet();
		List retList = new ArrayList();
		for (Object element : list) {
			if (set.add(element)) {
				retList.add(element);
			}
		}
		return retList;
	}

	private Util() {
	}
}
