/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * Dowser_Main.java
 *
 * Created on Apr 22, 2010, 12:40:26 PM
 */
package dowser;

import dowser.ui.StaticModelUI;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import ontology.ui.OntologyUI;
import uce.ui.UseCaseEditor;

/**
 *
 * @author chepa
 */
public class Dowser_Main extends javax.swing.JFrame {

	/** Creates new form Dowser_Main */
	public Dowser_Main() {
		initComponents();
		Dimension dim = this.getToolkit().getScreenSize();
		this.setLocation(dim.width / 2 - this.getPreferredSize().width / 2, dim.height / 2 - this.getPreferredSize().height / 2);
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
	// <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
	private void initComponents() {

		btnDowser = new javax.swing.JButton();
		btnUCE = new javax.swing.JButton();
		btnOntoEditor = new javax.swing.JButton();

		setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
		setName("Form"); // NOI18N
		getContentPane().setLayout(new java.awt.GridLayout(3, 1));

		btnDowser.setText("Launch Dowser"); // NOI18N
		btnDowser.setName("btnDowser"); // NOI18N
		btnDowser.addActionListener(new java.awt.event.ActionListener() {

			public void actionPerformed(java.awt.event.ActionEvent evt) {
				btnDowserActionPerformed(evt);
			}
		});
		getContentPane().add(btnDowser);

		btnUCE.setText("Launch Use-Case Editor"); // NOI18N
		btnUCE.setName("btnUCE"); // NOI18N
		btnUCE.addActionListener(new java.awt.event.ActionListener() {

			public void actionPerformed(java.awt.event.ActionEvent evt) {
				btnUCEActionPerformed(evt);
			}
		});
		getContentPane().add(btnUCE);

		btnOntoEditor.setText("Launch Ontology Editor"); // NOI18N
		btnOntoEditor.setName("btnOntoEditor"); // NOI18N
		btnOntoEditor.addActionListener(new java.awt.event.ActionListener() {

			public void actionPerformed(java.awt.event.ActionEvent evt) {
				btnOntoEditorActionPerformed(evt);
			}
		});
		getContentPane().add(btnOntoEditor);

		pack();
	}// </editor-fold>//GEN-END:initComponents

	private void btnDowserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDowserActionPerformed
		this.setVisible(false);
		StaticModelUI.main(null);
		final StaticModelUI dowserUI = StaticModelUI.getInstance();
		dowserUI.addWindowListener(new WindowAdapter() {

			@Override
			public void windowDeactivated(WindowEvent e) {
				if (!dowserUI.isVisible()) {
					Dowser_Main.this.setVisible(true);
				}
			}
		});
	}//GEN-LAST:event_btnDowserActionPerformed

	private void btnUCEActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnUCEActionPerformed
		this.setVisible(false);
		UseCaseEditor.main(null);
		final UseCaseEditor usecaseUI = UseCaseEditor.getInstance();
		usecaseUI.addWindowListener(new WindowAdapter() {

			@Override
			public void windowDeactivated(WindowEvent e) {
				if (!usecaseUI.isVisible()) {
					Dowser_Main.this.setVisible(true);
				}
			}
		});
	}//GEN-LAST:event_btnUCEActionPerformed

	private void btnOntoEditorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOntoEditorActionPerformed
		this.setVisible(false);
		OntologyUI.main(null);
		final OntologyUI ontoUI = OntologyUI.getInstance();
		ontoUI.addWindowListener(new WindowAdapter() {

			@Override
			public void windowDeactivated(WindowEvent e) {
				if (!ontoUI.isVisible()) {
					Dowser_Main.this.setVisible(true);
				}
			}
		});
	}//GEN-LAST:event_btnOntoEditorActionPerformed

	/**
	 * @param args the command line arguments
	 */
	public static void main(String args[]) {
		String stat_diag_script = System.getProperty(Const.STATIC_DIAGRAM_SCRIPT_KEY, null);
		if (stat_diag_script == null) {
			stat_diag_script = ".." + File.separator + ".." + File.separator + "dowser" + File.separator + "classExtractor-src-1.0" + File.separator + "class_diag";
		}
		String seq_diag_script = System.getProperty(Const.SEQ_DIAGRAM_SCRIPT_KEY, null);
		if (seq_diag_script == null) {
			seq_diag_script = ".." + File.separator + "seq_diag";
		}
		String wordnetDir = System.getProperty(Const.WORDNET_DIR, null);
		if (wordnetDir == null) {
			wordnetDir = "/usr/local/WordNet-3.0/dict";
		}
		if (stat_diag_script == null || seq_diag_script == null || wordnetDir == null || !(new File(stat_diag_script).exists()) || !(new File(seq_diag_script).exists()) || !(new File(wordnetDir).exists()) || !(new File(wordnetDir).isDirectory())) {
			StringBuilder sb = new StringBuilder("Some files are missing. You should set following properties : \n");
			sb.append(Const.WORDNET_DIR + "=<wordnet dict directory>\n");
			sb.append(Const.STATIC_DIAGRAM_SCRIPT_KEY + "=<static diagram generation script path>\n");
			sb.append(Const.SEQ_DIAGRAM_SCRIPT_KEY + "=<sequence diagram generation script path>\n");
			throw new IllegalArgumentException(sb.toString());
		}

		System.setProperty(Const.WORDNET_DIR, wordnetDir);
		System.setProperty(Const.STATIC_DIAGRAM_SCRIPT_KEY, stat_diag_script);
		System.setProperty(Const.SEQ_DIAGRAM_SCRIPT_KEY, seq_diag_script);
//		System.out.println(String.format("Using wordnetDir = %s, static diagram script = %s, seq diagram script = %s",wordnetDir, stat_diag_script, seq_diag_script));
//		System.setProperty("wordnet.database.dir", "/usr/local/WordNet-3.0/dict");
//		System.setProperty(Const.STATIC_DIAGRAM_SCRIPT_KEY, "/media/USB_Work/msproject/dowser/classExtractor-src-1.0/class_diag");
//		System.setProperty(Const.SEQ_DIAGRAM_SCRIPT_KEY, "/media/USB_Work/msproject/dowser/classExtractor-src-1.0/seq_diag");
		java.awt.EventQueue.invokeLater(new Runnable() {

			public void run() {
				new Dowser_Main().setVisible(true);
			}
		});
	}
	// Variables declaration - do not modify//GEN-BEGIN:variables
	private javax.swing.JButton btnDowser;
	private javax.swing.JButton btnOntoEditor;
	private javax.swing.JButton btnUCE;
	// End of variables declaration//GEN-END:variables
}

