#!/usr/bin/ruby
##############################################################################
#
#     File:  newRule.rb
#
#   Author:  Daniel Popescu
#
#  Version:  1.0, 15.12.2005
#
#  Comment:
#
#
#
# Dowser ClassExtractor, hereinafter (Software)
#
# Copyright 2005
# Georgia Tech Research Corporation
# Atlanta, Georgia  30332
# All Rights Reserved
#
# The following Software is posted on the Internet by the Georgia
# Tech Research Corporation (GTRC).  It was developed by students and
# faculty of the Georgia Institute of Technology.  GTRC hereby grants
# to the user a non-exclusive, royalty-free license to utilize such 
# Software for the user's own purposes pursuant to the following 
# conditions.
#
# THE SOFTWARE IS LICENSED ON AN "AS IS" BASIS.  GTRC MAKES NO
# WARRANTY THAT ALL ERRORS CAN BE OR HAVE BEEN ELIMINATED FROM THE
# SOFTWARE. GTRC SHALL NOT BE RESPONSIBLE FOR LOSSES OF ANY KIND
# RESULTING FROM THE USE OF THE SOFTWARE AND ITS ACCOMPANYING
# DOCUMENTATION, AND CAN IN NO WAY PROVIDE COMPENSATION FOR ANY
# LOSSES SUSTAINED, INCLUDING BUT NOT LIMITED TO ANY OBLIGATION,
# LIABILITY, RIGHT, CLAIM OR REMEDY FOR TORT, OR FOR ANY ACTUAL OR
# ALLEGED INFRINGEMENT OF PATENTS, COPYRIGHTS, TRADE SECRETS, OR
# SIMILAR RIGHTS OF THIRD PARTIES, NOR ANY BUSINESS EXPENSE, MACHINE
# DOWNTIME OR DAMAGES CAUSED LICENSEE BY ANY DEFICIENCY, DEFECT OR
# ERROR IN THE SOFTWARE OR MALFUNCTION THEREOF, NOR ANY INCIDENTAL
# OR CONSEQUENTIAL DAMAGES, HOWEVER CAUSED. GTRC DISCLAIMS ALL
# WARRANTIES, BOTH EXPRESS AND IMPLIED RESPECTING THE USE AND
# OPERATION OF THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION,
# INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR PARTICULAR PURPOSE AND ANY IMPLIED WARRANTY ARISING FROM
# COURSE OF PERFORMANCE, COURSE OF DEALING OR USAGE OF TRADE.  GTRC
# MAKES NO WARRANTY THAT THE SOFTWARE IS ADEQUATELY OR COMPLETELY
# DESCRIBED IN, OR BEHAVES IN ACCORDANCE WITH ANY ACCOMPANYING
# DOCUMENTATION.  THE USER OF THE SOFTWARE IS EXPECTED TO MAKE THE
# FINAL EVALUATION OF THE SOFTWARE'S USEFULNESS IN USER'S OWN
# ENVIRONMENT.
#
##############################################################################
def createHeader(className)
	filename = "./" + className + ".h"
	headerFile = File.new(filename, File::CREAT|File::TRUNC|File::WRONLY)

	headerFile << "#ifndef " + className.upcase + "_H\n"
	headerFile << "#define " + className.upcase + "_H\n"
	headerFile << "#include \"ClassExtractionRule.h\"\n"
	headerFile << "extern \"C\" {\n"
	headerFile << "#include \"link-includes.h\"\n}\n\n"
	headerFile << "class " + className 
	headerFile << " : public ClassExtractionRule \n{\n"
	headerFile << "\nprotected:\n"
	headerFile << "\n\tbool isThisRuleApplicable(Linkage linkage, \n"
	headerFile << "\t\t\tint currentWord, Sentence sent);\n\n"
	headerFile << "\n\tvoid applyThisRule(Linkage linkage, "
	headerFile << "int currentWord, Sentence sent,  \n"
	headerFile << "\t\t\tmap<string, DomainClass>& classMap);\n\n"
	headerFile << "\npublic:\n"
	headerFile << "\t" + className + "(){\n\t\truleName =\"" 
	headerFile << className + "\";\n\t}\n"
	headerFile << "\n};\n"
	headerFile << "#endif  // " + className.upcase + "_H\n\n"
	headerFile.close
end

def createBody(className)

	bodyFile = File.new("./" + className + ".cpp",
			File::CREAT|File::TRUNC|File::WRONLY)
	bodyFile << "#include \"" + className + ".h\"\n"
	bodyFile << "#include \"string.h\"\n"
	bodyFile << "#include \"DomainClass.h\"\n"
	bodyFile << "#include \"Association.h\"\n"
	bodyFile << "#include <string>\n"
	bodyFile << "extern \"C\" {\n"
	bodyFile << "#include \"check.h\"\n}\n\n"

	bodyFile << "bool " + className + "::isThisRuleApplicable"
	bodyFile << "(Linkage linkage,\n\t\tint currentWord, Sentence sent){"
	bodyFile << "\n\nreturn false;}\n\n"
	bodyFile << "void " + className + "::applyThisRule(Linkage linkage, "
	bodyFile << "int currentWord,\n\t\tSentence sent, map<string, "
	bodyFile << "DomainClass>& classMap){\n\n}\n"
	bodyFile.close
end

#main program
print "Enter the name of the new ClassExtractionRule file: "
className = gets.strip
print ("Create header\n")
createHeader(className)
print ("Create body\n")
createBody(className)
print "Class created."
