/***********************************************************************
*
*     File:  WordNet.cpp
*
*   Author:  Daniel Popescu
*
*  Version:  1.0, 15.12.2005
*
*  Comment:
*
*
*
* Dowser ClassExtractor, hereinafter (Software)
*
* Copyright 2005
* Georgia Tech Research Corporation
* Atlanta, Georgia  30332
* All Rights Reserved
*
* The following Software is posted on the Internet by the Georgia
* Tech Research Corporation (GTRC).  It was developed by students and
* faculty of the Georgia Institute of Technology.  GTRC hereby grants
* to the user a non-exclusive, royalty-free license to utilize such 
* Software for the user's own purposes pursuant to the following 
* conditions.
*
* THE SOFTWARE IS LICENSED ON AN "AS IS" BASIS.  GTRC MAKES NO
* WARRANTY THAT ALL ERRORS CAN BE OR HAVE BEEN ELIMINATED FROM THE
* SOFTWARE. GTRC SHALL NOT BE RESPONSIBLE FOR LOSSES OF ANY KIND
* RESULTING FROM THE USE OF THE SOFTWARE AND ITS ACCOMPANYING
* DOCUMENTATION, AND CAN IN NO WAY PROVIDE COMPENSATION FOR ANY
* LOSSES SUSTAINED, INCLUDING BUT NOT LIMITED TO ANY OBLIGATION,
* LIABILITY, RIGHT, CLAIM OR REMEDY FOR TORT, OR FOR ANY ACTUAL OR
* ALLEGED INFRINGEMENT OF PATENTS, COPYRIGHTS, TRADE SECRETS, OR
* SIMILAR RIGHTS OF THIRD PARTIES, NOR ANY BUSINESS EXPENSE, MACHINE
* DOWNTIME OR DAMAGES CAUSED LICENSEE BY ANY DEFICIENCY, DEFECT OR
* ERROR IN THE SOFTWARE OR MALFUNCTION THEREOF, NOR ANY INCIDENTAL
* OR CONSEQUENTIAL DAMAGES, HOWEVER CAUSED. GTRC DISCLAIMS ALL
* WARRANTIES, BOTH EXPRESS AND IMPLIED RESPECTING THE USE AND
* OPERATION OF THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR PARTICULAR PURPOSE AND ANY IMPLIED WARRANTY ARISING FROM
* COURSE OF PERFORMANCE, COURSE OF DEALING OR USAGE OF TRADE.  GTRC
* MAKES NO WARRANTY THAT THE SOFTWARE IS ADEQUATELY OR COMPLETELY
* DESCRIBED IN, OR BEHAVES IN ACCORDANCE WITH ANY ACCOMPANYING
* DOCUMENTATION.  THE USER OF THE SOFTWARE IS EXPECTED TO MAKE THE
* FINAL EVALUATION OF THE SOFTWARE'S USEFULNESS IN USER'S OWN
* ENVIRONMENT.
*
*********************************************************************/
#include "WordNet.h"
#include <stdlib.h>
extern "C" {
#include "wn.h"
}

WordNet::WordNet(){
	wninit();
}

void WordNet::getPlainForms(map<string, DomainClass>& classMap){
}


string& WordNet::getStem(string& word, int pos){
	char* temp = (char*) calloc(word.size()+1, sizeof(char));
	string*	endSteam = new string(word);
	string* front = new string("");
	int underScore = word.find_last_of("_");
	if (underScore != string::npos) {
		front->append(endSteam->substr(0,underScore+1));
		*endSteam = endSteam->substr(underScore+1);
	}
	temp = morphstr(getCopyOfString(*endSteam), pos);
	if (temp) {
		string* s = new string(morphstr(getCopyOfString(*endSteam)
					, pos));
		front->append(*s);
		delete s;
		return *front;
	}
	return word;
}

string& WordNet::getVerbStem(string word){
	return getStem(word, 2);
}

string& WordNet::getNounStem(string word){
	return getStem(word, 1);
}
