/***********************************************************************
*
*     File:  ModelPrinter.cpp
*
*   Author:  Daniel Popescu
*
*  Version:  1.0, 15.12.2005
*
*  Comment:
*
*
*
* Dowser ClassExtractor, hereinafter (Software)
*
* Copyright 2005
* Georgia Tech Research Corporation
* Atlanta, Georgia  30332
* All Rights Reserved
*
* The following Software is posted on the Internet by the Georgia
* Tech Research Corporation (GTRC).  It was developed by students and
* faculty of the Georgia Institute of Technology.  GTRC hereby grants
* to the user a non-exclusive, royalty-free license to utilize such 
* Software for the user's own purposes pursuant to the following 
* conditions.
*
* THE SOFTWARE IS LICENSED ON AN "AS IS" BASIS.  GTRC MAKES NO
* WARRANTY THAT ALL ERRORS CAN BE OR HAVE BEEN ELIMINATED FROM THE
* SOFTWARE. GTRC SHALL NOT BE RESPONSIBLE FOR LOSSES OF ANY KIND
* RESULTING FROM THE USE OF THE SOFTWARE AND ITS ACCOMPANYING
* DOCUMENTATION, AND CAN IN NO WAY PROVIDE COMPENSATION FOR ANY
* LOSSES SUSTAINED, INCLUDING BUT NOT LIMITED TO ANY OBLIGATION,
* LIABILITY, RIGHT, CLAIM OR REMEDY FOR TORT, OR FOR ANY ACTUAL OR
* ALLEGED INFRINGEMENT OF PATENTS, COPYRIGHTS, TRADE SECRETS, OR
* SIMILAR RIGHTS OF THIRD PARTIES, NOR ANY BUSINESS EXPENSE, MACHINE
* DOWNTIME OR DAMAGES CAUSED LICENSEE BY ANY DEFICIENCY, DEFECT OR
* ERROR IN THE SOFTWARE OR MALFUNCTION THEREOF, NOR ANY INCIDENTAL
* OR CONSEQUENTIAL DAMAGES, HOWEVER CAUSED. GTRC DISCLAIMS ALL
* WARRANTIES, BOTH EXPRESS AND IMPLIED RESPECTING THE USE AND
* OPERATION OF THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR PARTICULAR PURPOSE AND ANY IMPLIED WARRANTY ARISING FROM
* COURSE OF PERFORMANCE, COURSE OF DEALING OR USAGE OF TRADE.  GTRC
* MAKES NO WARRANTY THAT THE SOFTWARE IS ADEQUATELY OR COMPLETELY
* DESCRIBED IN, OR BEHAVES IN ACCORDANCE WITH ANY ACCOMPANYING
* DOCUMENTATION.  THE USER OF THE SOFTWARE IS EXPECTED TO MAKE THE
* FINAL EVALUATION OF THE SOFTWARE'S USEFULNESS IN USER'S OWN
* ENVIRONMENT.
*
*********************************************************************/

#include "ModelPrinter.h"
#include "WordNet.h"
#include <iostream>
#include <fstream>
#include <vector>
#include <string>
using namespace std;

void ModelPrinter::print(map<string, DomainClass>& classMap){
	WordNet wn;
	map<string, DomainClass>::iterator iter;
	map<string, DomainClass*>::iterator innerIterator;
	map<string, Association>::iterator assocIterator;
	vector<string>::iterator methodIterator;
	vector<string>::iterator attributeIterator;
	fstream output("static_model.java", ios::trunc | ios::out);
	
	for (iter = classMap.begin();
			iter!= classMap.end();
			iter++) {
		if (iter->second.getName() == "") continue;

		output << "class " 
			<< wn.getNounStem(iter->second.getName())
			<< " {" << endl;
		for(methodIterator = 
				iter->second.getMethods()->begin();
				methodIterator !=
				iter->second.getMethods()->end();
				methodIterator++){
			output << "method "
			<< wn.getVerbStem(*methodIterator) << endl;
		}

		for(attributeIterator = 
				iter->second.getAttributes()->begin();
				attributeIterator !=
				iter->second.getAttributes()->end();
				attributeIterator++){
			output << "attribute "
			<< *attributeIterator << "\n" << endl;	
		}
		output << "}" << endl;

		bool hasAggregations = !iter->second.getAggregations().empty();
		bool hasAssosiations = !iter->second.getAssociations().empty();

		if(hasAggregations || hasAssosiations) {
			if (hasAggregations) {
				map<string, DomainClass*> tempVector;
				tempVector = iter->second.
					getAggregations();
				for (innerIterator= tempVector.begin();
						innerIterator != 
						tempVector.end();
						innerIterator++) {
					output << "@aggregation " 
						<< wn.getNounStem(
						innerIterator->second->
						getName()) << endl;
				}
			} 

			if (hasAssosiations) {
				map<string, Association> tempAssoc 
					= iter->second.
					getAssociations();
				for (assocIterator = tempAssoc.begin();
						assocIterator != 
						tempAssoc.end();
						assocIterator++) {
					output << "@association " 
						<< wn.getVerbStem(
						assocIterator->
						second.getName())
						<< " " 
						<< wn.getNounStem(
						assocIterator->
						second.getTarget()->getName())
						<< endl;
				}
			} 
		}

		string superClass("");	
		if (iter->second.hasSuperClass()) {
			DomainClass super = iter->second.getSuperClass(); 
			output << "@superclass " << super.getName() << endl;
		}
	}
}
