/***********************************************************************
*
*     File:  HasRule.cpp
*
*   Author:  Daniel Popescu
*
*  Version:  1.0, 15.12.2005
*
*  Comment:
*
*
*
* Dowser ClassExtractor, hereinafter (Software)
*
* Copyright 2005
* Georgia Tech Research Corporation
* Atlanta, Georgia  30332
* All Rights Reserved
*
* The following Software is posted on the Internet by the Georgia
* Tech Research Corporation (GTRC).  It was developed by students and
* faculty of the Georgia Institute of Technology.  GTRC hereby grants
* to the user a non-exclusive, royalty-free license to utilize such 
* Software for the user's own purposes pursuant to the following 
* conditions.
*
* THE SOFTWARE IS LICENSED ON AN "AS IS" BASIS.  GTRC MAKES NO
* WARRANTY THAT ALL ERRORS CAN BE OR HAVE BEEN ELIMINATED FROM THE
* SOFTWARE. GTRC SHALL NOT BE RESPONSIBLE FOR LOSSES OF ANY KIND
* RESULTING FROM THE USE OF THE SOFTWARE AND ITS ACCOMPANYING
* DOCUMENTATION, AND CAN IN NO WAY PROVIDE COMPENSATION FOR ANY
* LOSSES SUSTAINED, INCLUDING BUT NOT LIMITED TO ANY OBLIGATION,
* LIABILITY, RIGHT, CLAIM OR REMEDY FOR TORT, OR FOR ANY ACTUAL OR
* ALLEGED INFRINGEMENT OF PATENTS, COPYRIGHTS, TRADE SECRETS, OR
* SIMILAR RIGHTS OF THIRD PARTIES, NOR ANY BUSINESS EXPENSE, MACHINE
* DOWNTIME OR DAMAGES CAUSED LICENSEE BY ANY DEFICIENCY, DEFECT OR
* ERROR IN THE SOFTWARE OR MALFUNCTION THEREOF, NOR ANY INCIDENTAL
* OR CONSEQUENTIAL DAMAGES, HOWEVER CAUSED. GTRC DISCLAIMS ALL
* WARRANTIES, BOTH EXPRESS AND IMPLIED RESPECTING THE USE AND
* OPERATION OF THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR PARTICULAR PURPOSE AND ANY IMPLIED WARRANTY ARISING FROM
* COURSE OF PERFORMANCE, COURSE OF DEALING OR USAGE OF TRADE.  GTRC
* MAKES NO WARRANTY THAT THE SOFTWARE IS ADEQUATELY OR COMPLETELY
* DESCRIBED IN, OR BEHAVES IN ACCORDANCE WITH ANY ACCOMPANYING
* DOCUMENTATION.  THE USER OF THE SOFTWARE IS EXPECTED TO MAKE THE
* FINAL EVALUATION OF THE SOFTWARE'S USEFULNESS IN USER'S OWN
* ENVIRONMENT.
*
*********************************************************************/
#include "HasRule.h"
extern "C" {
#include "check.h"
}
#include "DomainClass.h"
#include "string.h"
#include <iostream>
#include <string>

bool HasRule::isThisRuleApplicable(Linkage linkage, 
		int currentWord, Sentence sent){
	int subject = getConnectedWord(linkage, currentWord, "S");
	int object = getConnectedWord(linkage, currentWord, "O");
	bool hasOrHave = 
		(strcmp( sentence_get_word(sent, currentWord), "has") == 0 ||
			strcmp( sentence_get_word(sent, currentWord), "have")
			== 0 ||
			strcmp( sentence_get_word(sent, currentWord), 
				"contain") == 0 ||
			strcmp( sentence_get_word(sent, currentWord),
			       	"contains") == 0 ||
			strcmp( sentence_get_word(sent, currentWord),
			       	"possess") == 0 ||
			strcmp( sentence_get_word(sent, currentWord), 
				"possesses") == 0 ||
			strcmp( sentence_get_word(sent, currentWord), 
				"include") == 0 ||
			strcmp( sentence_get_word(sent, currentWord),
			       	"includes") == 0);
	return (subject >= 0 && object >= 0 && hasOrHave);
}

void HasRule::applyThisRule(Linkage linkage, int currentWord, Sentence sent,
		map<string, DomainClass>& classMap){
	char * tempString;
	string className;
	/* first class from subject*/
	DomainClass& domainClass = getDomainClass("S", currentWord,
		       	linkage, sent, classMap);
	/* second class from sentence object*/
	int object = getConnectedWord(linkage, currentWord, "O");
	int determinator = getConnectedWord(linkage, object, "D");
	char* connectorName = "O";
	if (determinator > -1 &&
		       	getConnectedWord(linkage, determinator, "YS") > -1) {
		connectorName = "YS";
		currentWord = determinator;
	} else if (strcmp(sentence_get_word(sent, object),"amount") == 0){
		int of = getConnectedWord(linkage, object, "Mp");
		if (of > -1) {
			currentWord = of;
			connectorName = "J";
		}

	}
	
	DomainClass& aggregatedClass = getDomainClass(connectorName,
		       	currentWord, linkage, sent, classMap);

	map<string, DomainClass*> aggregations = domainClass.getAggregations();
	aggregations[aggregatedClass.getName()] = &aggregatedClass;
	domainClass.setAggregations(aggregations);

	classMap[aggregatedClass.getName()] = aggregatedClass;
	classMap[domainClass.getName()] = domainClass; 
}

