/***********************************************************************
*
*     File:  ClassExtractor.h
*
*   Author:  Daniel Popescu
*
*  Version:  1.0, 15.12.2005
*
*  Comment:
*
*
*
* Dowser ClassExtractor, hereinafter (Software)
*
* Copyright 2005
* Georgia Tech Research Corporation
* Atlanta, Georgia  30332
* All Rights Reserved
*
* The following Software is posted on the Internet by the Georgia
* Tech Research Corporation (GTRC).  It was developed by students and
* faculty of the Georgia Institute of Technology.  GTRC hereby grants
* to the user a non-exclusive, royalty-free license to utilize such 
* Software for the user's own purposes pursuant to the following 
* conditions.
*
* THE SOFTWARE IS LICENSED ON AN "AS IS" BASIS.  GTRC MAKES NO
* WARRANTY THAT ALL ERRORS CAN BE OR HAVE BEEN ELIMINATED FROM THE
* SOFTWARE. GTRC SHALL NOT BE RESPONSIBLE FOR LOSSES OF ANY KIND
* RESULTING FROM THE USE OF THE SOFTWARE AND ITS ACCOMPANYING
* DOCUMENTATION, AND CAN IN NO WAY PROVIDE COMPENSATION FOR ANY
* LOSSES SUSTAINED, INCLUDING BUT NOT LIMITED TO ANY OBLIGATION,
* LIABILITY, RIGHT, CLAIM OR REMEDY FOR TORT, OR FOR ANY ACTUAL OR
* ALLEGED INFRINGEMENT OF PATENTS, COPYRIGHTS, TRADE SECRETS, OR
* SIMILAR RIGHTS OF THIRD PARTIES, NOR ANY BUSINESS EXPENSE, MACHINE
* DOWNTIME OR DAMAGES CAUSED LICENSEE BY ANY DEFICIENCY, DEFECT OR
* ERROR IN THE SOFTWARE OR MALFUNCTION THEREOF, NOR ANY INCIDENTAL
* OR CONSEQUENTIAL DAMAGES, HOWEVER CAUSED. GTRC DISCLAIMS ALL
* WARRANTIES, BOTH EXPRESS AND IMPLIED RESPECTING THE USE AND
* OPERATION OF THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR PARTICULAR PURPOSE AND ANY IMPLIED WARRANTY ARISING FROM
* COURSE OF PERFORMANCE, COURSE OF DEALING OR USAGE OF TRADE.  GTRC
* MAKES NO WARRANTY THAT THE SOFTWARE IS ADEQUATELY OR COMPLETELY
* DESCRIBED IN, OR BEHAVES IN ACCORDANCE WITH ANY ACCOMPANYING
* DOCUMENTATION.  THE USER OF THE SOFTWARE IS EXPECTED TO MAKE THE
* FINAL EVALUATION OF THE SOFTWARE'S USEFULNESS IN USER'S OWN
* ENVIRONMENT.
*
* DESCRIPTION:
* The class ClassExtractor reads text from stdin and 
* extracts classes from this natural language text.
* The text must be in English.
* The output depends on the installed printer object.
*
* Prerequisites:
* Depends on Link-Grammar 4.0
*
*/


#ifndef CLASSEXTRACTOR_H
#define CLASSEXTRACTOR_H
extern "C" {
#include "link-includes.h"
}
#include "ClassExtractionRule.h"
#include "DomainClass.h"
#include "Printer.h"
#include <string>
#include <vector>

using namespace std;

class ClassExtractor
{
	/*
	 * This printer is called for the output.
	 * It is set in the constructor*/
	Printer  * printer;

	/*
	 * This printer is called for the model output.
	 * It is set in the constructor*/
	Printer  * model_printer;

	/*
	 * This method creates the current default rules for
	 * the class extraction*/
	vector<ClassExtractionRule*>* setupRules();
public:
	ClassExtractor();
	/*
	 * Call this method to give the runtime control to 
	 * class extractor.
	 * This program starts ClassExtractor and reads the input
	 * from stdin*/
	int run(int argc, char **argv);

	vector<string>* extractActors(int argc, char **argv);
	/*
	 * This method applies the ClassExtractionRules to sentences.
	 * Every single string of "sentence" must be a single sentence.*/
	map<string, DomainClass>& extract(vector<string> * sentence,
			vector<ClassExtractionRule*>* rules);

	void removeActors(map<string, DomainClass>& classMap, 
			vector<string>& actors);

	void removeSystem(map<string, DomainClass>& classMap);

	void transformAggregationsIntoAttributes
		(map<string, DomainClass>& classMap);

	map<string, DomainClass> getAllAssociatedClasses(
		       	map<string, DomainClass>& classMap);


	void removeActor(map<string, DomainClass>& classMap, string& actor,
			bool isSystem);

};
#endif  // CLASSEXTRACTOR_H

