/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file.synset;

import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.VerbSynset;
import edu.smu.tspell.wordnet.WordSense;
import edu.smu.tspell.wordnet.impl.ExampleSentences;
import edu.smu.tspell.wordnet.impl.file.ReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.RelationshipPointers;
import edu.smu.tspell.wordnet.impl.file.RelationshipType;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SenseKey;

public class VerbReferenceSynset
extends ReferenceSynset
implements VerbSynset {
    private ExampleSentences examples;

    public VerbReferenceSynset(String string, String[] stringArray, SenseKey[] senseKeyArray, RelationshipPointers relationshipPointers, ExampleSentences exampleSentences, int n, int n2) {
        super(SynsetType.VERB, string, stringArray, senseKeyArray, relationshipPointers, n, n2);
        this.examples = exampleSentences;
    }

    public VerbSynset[] getHypernyms() throws RetrievalException {
        return this.getVerbSynsets(RelationshipType.HYPERNYM);
    }

    public VerbSynset[] getTroponyms() throws RetrievalException {
        return this.getVerbSynsets(RelationshipType.HYPONYM);
    }

    public VerbSynset[] getEntailments() throws RetrievalException {
        return this.getVerbSynsets(RelationshipType.ENTAILMENT);
    }

    public VerbSynset[] getOutcomes() throws RetrievalException {
        return this.getVerbSynsets(RelationshipType.CAUSE);
    }

    public WordSense[] getPhrases(String string) throws RetrievalException {
        return this.getReferences(RelationshipType.ALSO_SEE, string);
    }

    public VerbSynset[] getVerbGroup() throws RetrievalException {
        return this.getVerbSynsets(RelationshipType.VERB_GROUP);
    }

    public String[] getSentenceFrames() {
        return this.examples.getCommonFrames();
    }

    public String[] getSentenceFrames(String string) {
        return this.examples.getFrames(string);
    }

    public String[] getSentenceTemplates(String string) {
        return this.examples.getFormattedTemplates(string);
    }
}

