/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file.synset;

import edu.smu.tspell.wordnet.AdjectiveSynset;
import edu.smu.tspell.wordnet.NounSynset;
import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.WordNetException;
import edu.smu.tspell.wordnet.WordSense;
import edu.smu.tspell.wordnet.impl.file.ReferenceSynset;
import edu.smu.tspell.wordnet.impl.file.RelationshipPointers;
import edu.smu.tspell.wordnet.impl.file.RelationshipType;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SenseKey;
import edu.smu.tspell.wordnet.impl.file.WordPositions;

public class AdjectiveReferenceSynset
extends ReferenceSynset
implements AdjectiveSynset {
    private WordPositions wordPositions;

    public AdjectiveReferenceSynset(String string, String[] stringArray, SenseKey[] senseKeyArray, RelationshipPointers relationshipPointers, int n, int n2, WordPositions wordPositions) {
        this(SynsetType.ADJECTIVE, string, stringArray, senseKeyArray, relationshipPointers, n, n2, wordPositions);
    }

    AdjectiveReferenceSynset(SynsetType synsetType, String string, String[] stringArray, SenseKey[] senseKeyArray, RelationshipPointers relationshipPointers, int n, int n2, WordPositions wordPositions) {
        super(synsetType, string, stringArray, senseKeyArray, relationshipPointers, n, n2);
        this.wordPositions = wordPositions;
    }

    public AdjectiveSynset[] getSimilar() throws RetrievalException {
        return this.getAdjectiveSynsets(RelationshipType.SIMILAR);
    }

    public WordSense getParticiple(String string) throws RetrievalException {
        return this.getSingletonSense(RelationshipType.PARTICIPLE, string);
    }

    public WordSense[] getPertainyms(String string) throws RetrievalException {
        return this.getReferences(RelationshipType.PERTAINYM, string);
    }

    public NounSynset[] getAttributes() throws RetrievalException {
        return this.getNounSynsets(RelationshipType.ATTRIBUTE);
    }

    public AdjectiveSynset[] getRelated() throws RetrievalException {
        return this.getRelatedConcepts();
    }

    public AdjectiveSynset[] getRelatedConcepts() throws RetrievalException {
        return this.getAdjectiveSynsets(RelationshipType.ALSO_SEE);
    }

    public String getRequiredPosition(String string) {
        return this.wordPositions.getRequiredPosition(string);
    }

    public boolean isHeadSynset() throws WordNetException {
        return true;
    }
}

