/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.WordNetException;
import edu.smu.tspell.wordnet.impl.file.LeastRecentlyUsedCache;
import edu.smu.tspell.wordnet.impl.file.Morphology;
import edu.smu.tspell.wordnet.impl.file.SenseIndexEntry;
import edu.smu.tspell.wordnet.impl.file.SenseIndexReader;
import edu.smu.tspell.wordnet.impl.file.SynsetFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

public class WordFormLookup {
    private static final int DEFAULT_CACHE_SIZE = 500;
    private static int cacheSize = 500;
    private static WordFormLookup instance;
    private Map wordCategories = new WeakHashMap();
    private LeastRecentlyUsedCache cache = new LeastRecentlyUsedCache(cacheSize);

    public static synchronized WordFormLookup getInstance() {
        if (instance == null) {
            instance = new WordFormLookup();
        }
        return instance;
    }

    private WordFormLookup() {
    }

    public synchronized Synset[] getSynsets(String string, SynsetType[] synsetTypeArray, boolean bl) throws WordNetException {
        Synset[] synsetArray;
        ArrayList<Synset> arrayList = new ArrayList<Synset>();
        for (int i = 0; i < synsetTypeArray.length; ++i) {
            int n;
            synsetArray = this.getSynsets(string, synsetTypeArray[i]);
            for (n = 0; n < synsetArray.length; ++n) {
                if (arrayList.contains(synsetArray[n])) continue;
                arrayList.add(synsetArray[n]);
            }
            if (!bl) continue;
            String[] stringArray = this.getBaseFormCandidates(string, synsetTypeArray[i]);
            for (n = 0; n < stringArray.length; ++n) {
                synsetArray = this.getSynsets(stringArray[n], synsetTypeArray[i]);
                for (int j = 0; j < synsetArray.length; ++j) {
                    if (arrayList.contains(synsetArray[j])) continue;
                    arrayList.add(synsetArray[j]);
                }
            }
        }
        synsetArray = new Synset[arrayList.size()];
        arrayList.toArray(synsetArray);
        return synsetArray;
    }

    private Synset[] getSynsets(String string, SynsetType synsetType) {
        List list;
        ArrayList arrayList = new ArrayList();
        Map map = (Map)this.wordCategories.get(string);
        if (map == null) {
            map = this.loadSynsets(string);
            this.wordCategories.put(string, map);
            this.cache.put(string, string);
        }
        if ((list = (List)map.get(synsetType)) != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                if (arrayList.contains(list.get(i))) continue;
                arrayList.add(list.get(i));
            }
        }
        Synset[] synsetArray = new Synset[arrayList.size()];
        arrayList.toArray(synsetArray);
        return synsetArray;
    }

    private Map loadSynsets(String string) throws WordNetException {
        TreeMap<SynsetType, ArrayList<Synset>> treeMap = new TreeMap<SynsetType, ArrayList<Synset>>();
        SenseIndexReader senseIndexReader = SenseIndexReader.getInstance();
        Object[] objectArray = senseIndexReader.getLemmaEntries(string);
        Arrays.sort(objectArray);
        SynsetFactory synsetFactory = SynsetFactory.getInstance();
        for (int i = 0; i < objectArray.length; ++i) {
            Synset synset = synsetFactory.getSynset(((SenseIndexEntry)objectArray[i]).getSynsetPointer());
            SynsetType synsetType = synset.getType();
            ArrayList<Synset> arrayList = (ArrayList<Synset>)treeMap.get(synsetType);
            if (arrayList == null) {
                arrayList = new ArrayList<Synset>();
                treeMap.put(synsetType, arrayList);
            }
            arrayList.add(synset);
        }
        return treeMap;
    }

    private String[] getBaseFormCandidates(String string, SynsetType synsetType) {
        Morphology morphology = Morphology.getInstance();
        return morphology.getBaseFormCandidates(string, synsetType);
    }

    static {
        String string = "wordnet.cache.words";
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                cacheSize = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("'" + string2 + "' is an invalid " + "value for " + string + " and will be ignored.");
            }
        }
    }
}

