/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.WordSense;
import edu.smu.tspell.wordnet.impl.file.RelationshipType;
import java.util.HashMap;
import java.util.Map;

public class RelationshipReferences {
    private static final String SYNSET_KEY = "*";
    private Map sourceMaps = new HashMap();

    public void putSemanticRelationships(RelationshipType relationshipType, Synset[] synsetArray) {
        Map map = this.getSubMap(relationshipType, true);
        map.put(SYNSET_KEY, synsetArray);
    }

    public Synset[] getSemanticRelationships(RelationshipType relationshipType) {
        Map map = this.getSubMap(relationshipType, false);
        return map != null ? (Synset[])map.get(SYNSET_KEY) : null;
    }

    public void putLexicalRelationships(String string, RelationshipType relationshipType, WordSense[] wordSenseArray) {
        Map map = this.getSubMap(string, true);
        map.put(relationshipType, wordSenseArray);
    }

    public WordSense[] getLexicalRelationships(String string, RelationshipType relationshipType) {
        Map map = this.getSubMap(string, false);
        return map != null ? (WordSense[])map.get(relationshipType) : null;
    }

    private Map getSubMap(Object object, boolean bl) {
        HashMap hashMap = (HashMap)this.sourceMaps.get(object);
        if (hashMap == null && bl) {
            hashMap = new HashMap();
            this.sourceMaps.put(object, hashMap);
        }
        return hashMap;
    }
}

