/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.AdjectiveSynset;
import edu.smu.tspell.wordnet.NounSynset;
import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.VerbSynset;
import edu.smu.tspell.wordnet.WordNetException;
import edu.smu.tspell.wordnet.WordSense;
import edu.smu.tspell.wordnet.impl.AbstractSynset;
import edu.smu.tspell.wordnet.impl.file.RelationshipPointers;
import edu.smu.tspell.wordnet.impl.file.RelationshipReferences;
import edu.smu.tspell.wordnet.impl.file.RelationshipType;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import edu.smu.tspell.wordnet.impl.file.SenseIndexEntry;
import edu.smu.tspell.wordnet.impl.file.SenseIndexReader;
import edu.smu.tspell.wordnet.impl.file.SenseKey;
import edu.smu.tspell.wordnet.impl.file.SynsetFactory;
import edu.smu.tspell.wordnet.impl.file.SynsetPointer;
import edu.smu.tspell.wordnet.impl.file.TextTranslator;
import edu.smu.tspell.wordnet.impl.file.WordSensePointer;

public abstract class ReferenceSynset
extends AbstractSynset {
    private SenseKey[] senseKeys;
    private int[] tagCounts;
    private RelationshipPointers pointers;
    private int lexicalFileNumber;
    private int offset;
    private RelationshipReferences references = new RelationshipReferences();

    protected ReferenceSynset(SynsetType synsetType, String string, String[] stringArray, SenseKey[] senseKeyArray, RelationshipPointers relationshipPointers, int n, int n2) {
        super(synsetType, string, stringArray);
        this.senseKeys = senseKeyArray;
        this.pointers = relationshipPointers;
        this.lexicalFileNumber = n;
        this.offset = n2;
        this.tagCounts = new int[senseKeyArray.length];
        for (int i = 0; i < this.tagCounts.length; ++i) {
            this.tagCounts[i] = -1;
        }
    }

    public String[] getWordForms() {
        String[] stringArray = new String[this.senseKeys.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.senseKeys[i].getLemma();
        }
        return stringArray;
    }

    public synchronized int getTagCount(String string) throws WordNetException {
        int n = this.getWordIndex(TextTranslator.translateToExternalFormat(string));
        if (n < 0) {
            throw new WordNetException("Attempted to get the tag count for '" + string + "' from a synset that does not contain it.");
        }
        if (this.tagCounts[n] < 0) {
            SenseIndexEntry senseIndexEntry = this.getIndexEntry(this.senseKeys[n]);
            this.tagCounts[n] = senseIndexEntry.getTagCount();
        }
        return this.tagCounts[n];
    }

    private int getWordIndex(String string) {
        int n = -1;
        for (int i = 0; i < this.senseKeys.length; ++i) {
            if (!string.equalsIgnoreCase(this.senseKeys[i].getLemma())) continue;
            n = i;
            break;
        }
        return n;
    }

    public int getLexicalFileNumber() {
        return this.lexicalFileNumber;
    }

    public int getOffset() {
        return this.offset;
    }

    public WordSense[] getAntonyms(String string) throws WordNetException {
        return this.getReferences(RelationshipType.ANTONYM, string);
    }

    public WordSense[] getDerivationallyRelatedForms(String string) throws RetrievalException {
        return this.getReferences(RelationshipType.RELATED_FORM, string);
    }

    protected synchronized Synset[] getSynsets(RelationshipType relationshipType) throws WordNetException {
        Synset[] synsetArray = this.getReferences(relationshipType);
        if (synsetArray == null) {
            synsetArray = this.resolvePointers(relationshipType);
        }
        return synsetArray;
    }

    protected synchronized NounSynset[] getNounSynsets(RelationshipType relationshipType) throws WordNetException {
        Synset[] synsetArray = (NounSynset[])this.getReferences(relationshipType);
        if (synsetArray == null) {
            Synset[] synsetArray2 = this.resolvePointers(relationshipType);
            synsetArray = new NounSynset[synsetArray2.length];
            System.arraycopy(synsetArray2, 0, synsetArray, 0, synsetArray2.length);
            this.putReferences(relationshipType, synsetArray);
        }
        return synsetArray;
    }

    protected synchronized VerbSynset[] getVerbSynsets(RelationshipType relationshipType) throws WordNetException {
        Synset[] synsetArray = (VerbSynset[])this.getReferences(relationshipType);
        if (synsetArray == null) {
            Synset[] synsetArray2 = this.resolvePointers(relationshipType);
            synsetArray = new VerbSynset[synsetArray2.length];
            System.arraycopy(synsetArray2, 0, synsetArray, 0, synsetArray2.length);
            this.putReferences(relationshipType, synsetArray);
        }
        return synsetArray;
    }

    protected synchronized AdjectiveSynset[] getAdjectiveSynsets(RelationshipType relationshipType) throws WordNetException {
        Synset[] synsetArray = (AdjectiveSynset[])this.getReferences(relationshipType);
        if (synsetArray == null) {
            Synset[] synsetArray2 = this.resolvePointers(relationshipType);
            synsetArray = new AdjectiveSynset[synsetArray2.length];
            System.arraycopy(synsetArray2, 0, synsetArray, 0, synsetArray2.length);
            this.putReferences(relationshipType, synsetArray);
        }
        return synsetArray;
    }

    private Synset[] getReferences(RelationshipType relationshipType) {
        return this.references.getSemanticRelationships(relationshipType);
    }

    private void putReferences(RelationshipType relationshipType, Synset[] synsetArray) {
        this.references.putSemanticRelationships(relationshipType, synsetArray);
    }

    private Synset[] resolvePointers(RelationshipType relationshipType) throws WordNetException {
        Synset[] synsetArray = null;
        SynsetPointer[] synsetPointerArray = this.getPointers(relationshipType);
        if (synsetPointerArray != null) {
            SynsetFactory synsetFactory = SynsetFactory.getInstance();
            synsetArray = new Synset[synsetPointerArray.length];
            for (int i = 0; i < synsetArray.length; ++i) {
                synsetArray[i] = synsetFactory.getSynset(synsetPointerArray[i]);
            }
            this.clearPointers(relationshipType);
        }
        return synsetArray;
    }

    private SynsetPointer[] getPointers(RelationshipType relationshipType) {
        return this.pointers.getSemanticRelationships(relationshipType);
    }

    private void clearPointers(RelationshipType relationshipType) {
        this.pointers.removeAllSemanticRelationships(relationshipType);
    }

    public NounSynset[] getTopics() throws WordNetException {
        return this.getNounSynsets(RelationshipType.DOMAIN_TOPIC);
    }

    public NounSynset[] getRegions() throws WordNetException {
        return this.getNounSynsets(RelationshipType.DOMAIN_REGION);
    }

    public NounSynset[] getUsages() throws WordNetException {
        return this.getNounSynsets(RelationshipType.DOMAIN_USAGE);
    }

    protected WordSense getSingletonSense(RelationshipType relationshipType, String string) throws WordNetException {
        WordSense wordSense;
        WordSense[] wordSenseArray = this.getReferences(RelationshipType.PARTICIPLE, string);
        switch (wordSenseArray.length) {
            case 0: {
                wordSense = null;
                break;
            }
            case 1: {
                wordSense = wordSenseArray[0];
                break;
            }
            default: {
                throw new WordNetException("Can't resolve to a exactly one reference of type " + relationshipType + ": " + this);
            }
        }
        return wordSense;
    }

    protected synchronized WordSense[] getReferences(RelationshipType relationshipType, String string) throws WordNetException {
        WordSense[] wordSenseArray = this.references.getLexicalRelationships(string = TextTranslator.translateToExternalFormat(string), relationshipType);
        if (wordSenseArray == null) {
            WordSensePointer[] wordSensePointerArray = this.pointers.getLexicalRelationships(string, relationshipType);
            wordSenseArray = new WordSense[wordSensePointerArray.length];
            SynsetFactory synsetFactory = SynsetFactory.getInstance();
            for (int i = 0; i < wordSenseArray.length; ++i) {
                Synset synset = synsetFactory.getSynset(wordSensePointerArray[i]);
                String[] stringArray = synset.getWordForms();
                wordSenseArray[i] = new WordSense(stringArray[wordSensePointerArray[i].getWordNumber() - 1], synset);
            }
            this.references.putLexicalRelationships(string, relationshipType, wordSenseArray);
        }
        return wordSenseArray;
    }

    protected SenseKey getSenseKey(int n) {
        return this.senseKeys[n];
    }

    protected SenseIndexEntry getIndexEntry(SenseKey senseKey) {
        SenseIndexEntry senseIndexEntry = null;
        SenseIndexReader senseIndexReader = SenseIndexReader.getInstance();
        SenseIndexEntry[] senseIndexEntryArray = senseIndexReader.getAllEntries(senseKey.getPartialSenseKeyText());
        for (int i = 0; i < senseIndexEntryArray.length; ++i) {
            if (senseIndexEntryArray[i].getSynsetOffset() != this.getOffset()) continue;
            senseIndexEntry = senseIndexEntryArray[i];
            break;
        }
        return senseIndexEntry;
    }

    public int hashCode() {
        return this.getOffset();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null) {
            ReferenceSynset referenceSynset = (ReferenceSynset)object;
            bl = this.getType().equals(referenceSynset.getType()) && this.getOffset() == referenceSynset.getOffset();
        }
        return bl;
    }

    public String toString() {
        String[] stringArray = new String[]{"Noun", "Verb", "Adjective", "Adverb", "AdjectiveSatellite"};
        StringBuffer stringBuffer = new StringBuffer(stringArray[this.getType().getCode() - 1] + "@" + this.getOffset() + "[");
        String[] stringArray2 = this.getWordForms();
        for (int i = 0; i < stringArray2.length; ++i) {
            stringBuffer.append((i > 0 ? "," : "") + stringArray2[i]);
        }
        stringBuffer.append("] - ");
        stringBuffer.append(this.getDefinition());
        return stringBuffer.toString();
    }
}

