/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class LeastRecentlyUsedCache {
    private int maximumEntries;
    private Map data;
    private Map keyTimes;
    private TreeMap timeKeys;
    private long lastTime = 0L;

    public LeastRecentlyUsedCache(int n) {
        this.maximumEntries = n;
        this.data = new HashMap(n);
        this.keyTimes = new HashMap(n);
        this.timeKeys = new TreeMap();
    }

    public synchronized void put(Object object, Object object2) {
        if (this.maximumEntries > 0) {
            Object object3 = this.keyTimes.get(object);
            if (object3 == null) {
                if (this.data.size() >= this.maximumEntries) {
                    Object k = this.timeKeys.firstKey();
                    Object v = this.timeKeys.remove(k);
                    this.keyTimes.remove(v);
                    this.data.remove(v);
                }
                this.data.put(object, object2);
            } else {
                object = this.timeKeys.remove(object3);
            }
            object3 = this.getUniqueTimeKey();
            this.timeKeys.put(object3, object);
            this.keyTimes.put(object, object3);
        }
    }

    public synchronized Object get(Object object) {
        Object v = this.data.get(object);
        if (v != null || this.data.containsKey(object)) {
            this.markReferenced(object);
        }
        return v;
    }

    private void markReferenced(Object object) {
        Object v = this.keyTimes.get(object);
        object = this.timeKeys.remove(v);
        Object object2 = this.getUniqueTimeKey();
        this.timeKeys.put(object2, object);
        this.keyTimes.put(object, object2);
    }

    private Object getUniqueTimeKey() {
        long l = System.currentTimeMillis();
        if (l <= this.lastTime) {
            l = this.lastTime + 1L;
        }
        this.lastTime = l;
        return new Long(l);
    }
}

