/***********************************************************************
*
*     File:  SubjectRule.cpp
*
*   Author:  Daniel Popescu
*
*  Version:  1.0, 15.12.2005
*
*  Comment:
*
*
*
* Dowser ClassExtractor, hereinafter (Software)
*
* Copyright 2005
* Georgia Tech Research Corporation
* Atlanta, Georgia  30332
* All Rights Reserved
*
* The following Software is posted on the Internet by the Georgia
* Tech Research Corporation (GTRC).  It was developed by students and
* faculty of the Georgia Institute of Technology.  GTRC hereby grants
* to the user a non-exclusive, royalty-free license to utilize such 
* Software for the user's own purposes pursuant to the following 
* conditions.
*
* THE SOFTWARE IS LICENSED ON AN "AS IS" BASIS.  GTRC MAKES NO
* WARRANTY THAT ALL ERRORS CAN BE OR HAVE BEEN ELIMINATED FROM THE
* SOFTWARE. GTRC SHALL NOT BE RESPONSIBLE FOR LOSSES OF ANY KIND
* RESULTING FROM THE USE OF THE SOFTWARE AND ITS ACCOMPANYING
* DOCUMENTATION, AND CAN IN NO WAY PROVIDE COMPENSATION FOR ANY
* LOSSES SUSTAINED, INCLUDING BUT NOT LIMITED TO ANY OBLIGATION,
* LIABILITY, RIGHT, CLAIM OR REMEDY FOR TORT, OR FOR ANY ACTUAL OR
* ALLEGED INFRINGEMENT OF PATENTS, COPYRIGHTS, TRADE SECRETS, OR
* SIMILAR RIGHTS OF THIRD PARTIES, NOR ANY BUSINESS EXPENSE, MACHINE
* DOWNTIME OR DAMAGES CAUSED LICENSEE BY ANY DEFICIENCY, DEFECT OR
* ERROR IN THE SOFTWARE OR MALFUNCTION THEREOF, NOR ANY INCIDENTAL
* OR CONSEQUENTIAL DAMAGES, HOWEVER CAUSED. GTRC DISCLAIMS ALL
* WARRANTIES, BOTH EXPRESS AND IMPLIED RESPECTING THE USE AND
* OPERATION OF THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR PARTICULAR PURPOSE AND ANY IMPLIED WARRANTY ARISING FROM
* COURSE OF PERFORMANCE, COURSE OF DEALING OR USAGE OF TRADE.  GTRC
* MAKES NO WARRANTY THAT THE SOFTWARE IS ADEQUATELY OR COMPLETELY
* DESCRIBED IN, OR BEHAVES IN ACCORDANCE WITH ANY ACCOMPANYING
* DOCUMENTATION.  THE USER OF THE SOFTWARE IS EXPECTED TO MAKE THE
* FINAL EVALUATION OF THE SOFTWARE'S USEFULNESS IN USER'S OWN
* ENVIRONMENT.
*
*********************************************************************/
#include "SubjectRule.h"
#include "string.h"
#include "DomainClass.h"
#include "Association.h"
#include "WordNet.h"
#include <string>
extern "C" {
#include "check.h"
}

bool SubjectRule::isThisRuleApplicable(Linkage linkage,
		int currentWord, Sentence sent){
	WordNet wn;
	int subject = getConnectedWord(linkage, currentWord, "S");
	int object = getConnectedWord(linkage, currentWord, "O");
	int determinator = getConnectedWord(linkage, currentWord, "D");
	int conditionalSingularModifier =
	       	getConnectedWord(linkage, subject, "Cs"); 
	int conditionalPluralModifier =
	       	getConnectedWord(linkage, subject, "Cp"); 
	int conditionalSubClause =
	       	getConnectedWord(linkage, subject, "CO");

	char* tempString = sentence_get_word(sent, currentWord);
	CHECK(tempString != NULL, true);
	string methodName(tempString);
        methodName = wn.getVerbStem(tempString);

	int firstWord = 1;
	
return 	methodName != "be" && methodName != "become"
	&& (strcmp(sentence_get_word(sent, firstWord), "if") == 0 ||
			strcmp( sentence_get_word(sent, firstWord), 
				"when") == 0)
	&& (conditionalPluralModifier == -1)
			&& (conditionalSingularModifier == -1)
			&& (subject > 0) 
			&& (determinator == -1) 
			&& (conditionalSubClause > -1)
			&& (object == -1);}

void SubjectRule::applyThisRule(Linkage linkage, int currentWord,
		Sentence sent, map<string, DomainClass>& classMap){
	WordNet wn;
	int connectedWord = getConnectedWord(linkage, currentWord, "S");
	string className = getTerm(linkage, sent, connectedWord);
	DomainClass& domainClass = getDomainClass(className, classMap);

	char* tempString = sentence_get_word(sent, currentWord);
	CHECK(tempString != NULL, true);
	string* methodName = new string(tempString);
	*methodName = wn.getVerbStem(*methodName);
	domainClass.addMethod(*methodName);

	classMap[domainClass.getName()] = domainClass;
}
