/***********************************************************************
*
*     File:  InfinitiveObjectRule.cpp
*
*   Author:  Daniel Popescu
*
*  Version:  1.0, 15.12.2005
*
*  Comment:
*
*
*
* Dowser ClassExtractor, hereinafter (Software)
*
* Copyright 2005
* Georgia Tech Research Corporation
* Atlanta, Georgia  30332
* All Rights Reserved
*
* The following Software is posted on the Internet by the Georgia
* Tech Research Corporation (GTRC).  It was developed by students and
* faculty of the Georgia Institute of Technology.  GTRC hereby grants
* to the user a non-exclusive, royalty-free license to utilize such 
* Software for the user's own purposes pursuant to the following 
* conditions.
*
* THE SOFTWARE IS LICENSED ON AN "AS IS" BASIS.  GTRC MAKES NO
* WARRANTY THAT ALL ERRORS CAN BE OR HAVE BEEN ELIMINATED FROM THE
* SOFTWARE. GTRC SHALL NOT BE RESPONSIBLE FOR LOSSES OF ANY KIND
* RESULTING FROM THE USE OF THE SOFTWARE AND ITS ACCOMPANYING
* DOCUMENTATION, AND CAN IN NO WAY PROVIDE COMPENSATION FOR ANY
* LOSSES SUSTAINED, INCLUDING BUT NOT LIMITED TO ANY OBLIGATION,
* LIABILITY, RIGHT, CLAIM OR REMEDY FOR TORT, OR FOR ANY ACTUAL OR
* ALLEGED INFRINGEMENT OF PATENTS, COPYRIGHTS, TRADE SECRETS, OR
* SIMILAR RIGHTS OF THIRD PARTIES, NOR ANY BUSINESS EXPENSE, MACHINE
* DOWNTIME OR DAMAGES CAUSED LICENSEE BY ANY DEFICIENCY, DEFECT OR
* ERROR IN THE SOFTWARE OR MALFUNCTION THEREOF, NOR ANY INCIDENTAL
* OR CONSEQUENTIAL DAMAGES, HOWEVER CAUSED. GTRC DISCLAIMS ALL
* WARRANTIES, BOTH EXPRESS AND IMPLIED RESPECTING THE USE AND
* OPERATION OF THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR PARTICULAR PURPOSE AND ANY IMPLIED WARRANTY ARISING FROM
* COURSE OF PERFORMANCE, COURSE OF DEALING OR USAGE OF TRADE.  GTRC
* MAKES NO WARRANTY THAT THE SOFTWARE IS ADEQUATELY OR COMPLETELY
* DESCRIBED IN, OR BEHAVES IN ACCORDANCE WITH ANY ACCOMPANYING
* DOCUMENTATION.  THE USER OF THE SOFTWARE IS EXPECTED TO MAKE THE
* FINAL EVALUATION OF THE SOFTWARE'S USEFULNESS IN USER'S OWN
* ENVIRONMENT.
*
*********************************************************************/
#include "InfinitiveObjectRule.h"
#include "string.h"
#include "DomainClass.h"
#include "Association.h"
#include <string>
extern "C" {
#include "check.h"
}

bool InfinitiveObjectRule::isThisRuleApplicable(Linkage linkage,
		int currentWord, Sentence sent){
	int tempWord = getConnectedWord(linkage, currentWord, "P");
	tempWord = getConnectedWord(linkage, tempWord, "Ix");
	tempWord = getConnectedWord(linkage, tempWord, "TO");
	int subject =  getConnectedWord(linkage, tempWord, "S");
	tempWord = getConnectedWord(linkage, currentWord, "MV");
	int object =  getConnectedWord(linkage, tempWord, "J");	
	return (object >= 0 && subject >= 0 && tempWord >= 0);
}

void InfinitiveObjectRule::applyThisRule(Linkage linkage, int currentWord,
		Sentence sent, map<string, DomainClass>& classMap){
	char * tempString;
	map<string, Association> associations;
	int tempWord = getConnectedWord(linkage, currentWord, "P");
	tempWord = getConnectedWord(linkage, tempWord, "Ix");
	tempWord = getConnectedWord(linkage, tempWord, "TO");
	DomainClass& domainClass = getDomainClass("S", tempWord,
		       	linkage, sent, classMap);

	/*--*/
	tempWord = getConnectedWord(linkage, currentWord, "MV");
	DomainClass& receiverClass = getDomainClass("J", tempWord,
		       	linkage, sent, classMap); 

	tempString = sentence_get_word(sent, currentWord);
	CHECK(tempString != NULL, true);
	string* associationName = new string(tempString);
	associationName->append("_");
	associationName->append(sentence_get_word(sent, tempWord));
	Association* assoc = new Association(*associationName, &receiverClass);
	associationName->append(*associationName);
	associationName->append(domainClass.getName());
	associations[*associationName] = *assoc;
	domainClass.setAssociations(associations);
	
	classMap[domainClass.getName()] = domainClass; 
	classMap[receiverClass.getName()] = receiverClass; 
}
