/***********************************************************************
*
*     File:  ClassExtractionRule.h
*
*   Author:  Daniel Popescu
*
*  Version:  1.0, 15.12.2005
*
*  Comment:
*
*
*
* Dowser ClassExtractor, hereinafter (Software)
*
* Copyright 2005
* Georgia Tech Research Corporation
* Atlanta, Georgia  30332
* All Rights Reserved
*
* The following Software is posted on the Internet by the Georgia
* Tech Research Corporation (GTRC).  It was developed by students and
* faculty of the Georgia Institute of Technology.  GTRC hereby grants
* to the user a non-exclusive, royalty-free license to utilize such 
* Software for the user's own purposes pursuant to the following 
* conditions.
*
* THE SOFTWARE IS LICENSED ON AN "AS IS" BASIS.  GTRC MAKES NO
* WARRANTY THAT ALL ERRORS CAN BE OR HAVE BEEN ELIMINATED FROM THE
* SOFTWARE. GTRC SHALL NOT BE RESPONSIBLE FOR LOSSES OF ANY KIND
* RESULTING FROM THE USE OF THE SOFTWARE AND ITS ACCOMPANYING
* DOCUMENTATION, AND CAN IN NO WAY PROVIDE COMPENSATION FOR ANY
* LOSSES SUSTAINED, INCLUDING BUT NOT LIMITED TO ANY OBLIGATION,
* LIABILITY, RIGHT, CLAIM OR REMEDY FOR TORT, OR FOR ANY ACTUAL OR
* ALLEGED INFRINGEMENT OF PATENTS, COPYRIGHTS, TRADE SECRETS, OR
* SIMILAR RIGHTS OF THIRD PARTIES, NOR ANY BUSINESS EXPENSE, MACHINE
* DOWNTIME OR DAMAGES CAUSED LICENSEE BY ANY DEFICIENCY, DEFECT OR
* ERROR IN THE SOFTWARE OR MALFUNCTION THEREOF, NOR ANY INCIDENTAL
* OR CONSEQUENTIAL DAMAGES, HOWEVER CAUSED. GTRC DISCLAIMS ALL
* WARRANTIES, BOTH EXPRESS AND IMPLIED RESPECTING THE USE AND
* OPERATION OF THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR PARTICULAR PURPOSE AND ANY IMPLIED WARRANTY ARISING FROM
* COURSE OF PERFORMANCE, COURSE OF DEALING OR USAGE OF TRADE.  GTRC
* MAKES NO WARRANTY THAT THE SOFTWARE IS ADEQUATELY OR COMPLETELY
* DESCRIBED IN, OR BEHAVES IN ACCORDANCE WITH ANY ACCOMPANYING
* DOCUMENTATION.  THE USER OF THE SOFTWARE IS EXPECTED TO MAKE THE
* FINAL EVALUATION OF THE SOFTWARE'S USEFULNESS IN USER'S OWN
* ENVIRONMENT.
*
*********************************************************************/
#ifndef CLASSEXTRACTIONRULE_H
#define CLASSEXTRACTIONRULE_H
extern "C" 
{
#include "link-includes.h"
}
#include "DomainClass.h"
#include <vector>
#include <map>
#include <string>
using namespace std;

class ClassExtractionRule
{
protected:

	string ruleName;
	
	/*
	 * This method checks if a concrete rule is applicable to a
	 * given sentence*/
	virtual bool isThisRuleApplicable(Linkage linkage, 
			int currentWord, Sentence sent)=0;

	/*
	 * This method applies the concrete rule and add the extracted
	 * new classes to the classMap.*/ 
	virtual void applyThisRule(Linkage linkage, int currentWord,
		       	Sentence sent, map<string, DomainClass>& classMap)=0; 

	/*
	 * this method serves as a factory method for DomainClass 
	 * in all ClassExtractionRules 
	 */
	DomainClass& getDomainClass(string& className, 
			map<string, DomainClass>& classMap); 

	DomainClass& getDomainClass(char* connector, 
			int currentWord, Linkage linkage, Sentence sent,	
			map<string, DomainClass>& classMap); 

	/*
	 * returns the word position in the sentence to which "word" is
	 * connected by the given connector.
	 * returns -1 if the connector does not exist
	 * */
	int getConnectedWord(Linkage linkage, int word, char * connector);

	string& getTerm(Linkage linkage, Sentence sent, int noun);

public:
	virtual ~ClassExtractionRule(){}
	string printRuleName() {
		return ruleName;
	}
	bool apply(Linkage linkage, int currentWord, Sentence sent,
			map<string, DomainClass>& classMap); 

};
#endif  // CLASSEXTRACTIONRULE_H

