/***********************************************************************
*
*     File:  ClassExtractionRule.cpp
*
*   Author:  Daniel Popescu
*
*  Version:  1.0, 15.12.2005
*
*  Comment:
*
*
*
* Dowser ClassExtractor, hereinafter (Software)
*
* Copyright 2005
* Georgia Tech Research Corporation
* Atlanta, Georgia  30332
* All Rights Reserved
*
* The following Software is posted on the Internet by the Georgia
* Tech Research Corporation (GTRC).  It was developed by students and
* faculty of the Georgia Institute of Technology.  GTRC hereby grants
* to the user a non-exclusive, royalty-free license to utilize such 
* Software for the user's own purposes pursuant to the following 
* conditions.
*
* THE SOFTWARE IS LICENSED ON AN "AS IS" BASIS.  GTRC MAKES NO
* WARRANTY THAT ALL ERRORS CAN BE OR HAVE BEEN ELIMINATED FROM THE
* SOFTWARE. GTRC SHALL NOT BE RESPONSIBLE FOR LOSSES OF ANY KIND
* RESULTING FROM THE USE OF THE SOFTWARE AND ITS ACCOMPANYING
* DOCUMENTATION, AND CAN IN NO WAY PROVIDE COMPENSATION FOR ANY
* LOSSES SUSTAINED, INCLUDING BUT NOT LIMITED TO ANY OBLIGATION,
* LIABILITY, RIGHT, CLAIM OR REMEDY FOR TORT, OR FOR ANY ACTUAL OR
* ALLEGED INFRINGEMENT OF PATENTS, COPYRIGHTS, TRADE SECRETS, OR
* SIMILAR RIGHTS OF THIRD PARTIES, NOR ANY BUSINESS EXPENSE, MACHINE
* DOWNTIME OR DAMAGES CAUSED LICENSEE BY ANY DEFICIENCY, DEFECT OR
* ERROR IN THE SOFTWARE OR MALFUNCTION THEREOF, NOR ANY INCIDENTAL
* OR CONSEQUENTIAL DAMAGES, HOWEVER CAUSED. GTRC DISCLAIMS ALL
* WARRANTIES, BOTH EXPRESS AND IMPLIED RESPECTING THE USE AND
* OPERATION OF THE SOFTWARE AND ANY ACCOMPANYING DOCUMENTATION,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
* FOR PARTICULAR PURPOSE AND ANY IMPLIED WARRANTY ARISING FROM
* COURSE OF PERFORMANCE, COURSE OF DEALING OR USAGE OF TRADE.  GTRC
* MAKES NO WARRANTY THAT THE SOFTWARE IS ADEQUATELY OR COMPLETELY
* DESCRIBED IN, OR BEHAVES IN ACCORDANCE WITH ANY ACCOMPANYING
* DOCUMENTATION.  THE USER OF THE SOFTWARE IS EXPECTED TO MAKE THE
* FINAL EVALUATION OF THE SOFTWARE'S USEFULNESS IN USER'S OWN
* ENVIRONMENT.
*
*********************************************************************/

#include "ClassExtractionRule.h"
extern "C" {
#include "check.h"
}
#include <iostream>
#include <algorithm> 
#include "WordNet.h"
using namespace std;

bool ClassExtractionRule::apply(Linkage linkage, int currentWord,
	       	Sentence sent, map<string, DomainClass>& classMap) {

	bool ruleApplied = isThisRuleApplicable(linkage, currentWord, sent);
	if (ruleApplied) {
		applyThisRule(linkage, currentWord, sent, classMap );
	} 
	return ruleApplied;
}

string& ClassExtractionRule::getTerm(Linkage linkage, Sentence sent, 
		int noun) {
	string *className = new string;
	char* tempString = sentence_get_word(sent, noun);
	CHECK(tempString != NULL, true);
	string mainNoun(tempString);
	int nounAttribute = getConnectedWord(linkage, noun, "AN");
	if (nounAttribute >= 0) {
	tempString = sentence_get_word(sent, nounAttribute);
	CHECK(tempString != NULL, true);
	delete className;
	className = new string(tempString);
	className->append("_");
	}
	className->append(mainNoun);
	return *className;
}

int ClassExtractionRule::getConnectedWord(Linkage linkage, 
		int word, char * connector){
	int i, numb_links;
	char * tempConnector;
	numb_links = linkage_get_num_links(linkage);
	CHECK(numb_links >= 0, true);
	if (numb_links > 0) {

	for(i = numb_links-1;  i > 0; --i) {
		if(linkage_get_link_lword(linkage, i) == word) {
			tempConnector 
				= linkage_get_link_label(linkage, i);
			if (strcmp (tempConnector, connector) == 0) {
				return linkage_get_link_rword(linkage, i);
			} else if (strcmp (tempConnector, connector) > 0) {
				int length = strlen(connector);
				if (strncmp(tempConnector, connector,
							length) == 0){
					return linkage_get_link_rword
						(linkage, i);
				}
			}
		}
		if(linkage_get_link_rword(linkage, i) == word) {
			tempConnector 
				= linkage_get_link_label(linkage, i);
			if (strcmp (tempConnector, connector) == 0) {
				return linkage_get_link_lword(linkage, i);
			} else if (strcmp (tempConnector, connector) > 0) {
				int length = strlen(connector);
				if (strncmp(tempConnector, connector,
							length) == 0){
					return linkage_get_link_lword
						(linkage, i);
				}
			}

		}
	}}
	return -1;
}

DomainClass& ClassExtractionRule::getDomainClass(char* connector, 
	       int currentWord, Linkage linkage, Sentence sent,	
		map<string, DomainClass>& classMap){
	int connectedWord = getConnectedWord(linkage, currentWord, connector);
	CHECK(connectedWord >= 0,true);
	string className = getTerm(linkage, sent, connectedWord);
	replace(className.begin(),className.end(),'-','_'); 
	return getDomainClass(className, classMap);
}

DomainClass& ClassExtractionRule::getDomainClass(string& className, 
		map<string, DomainClass>& classMap){
	WordNet wn;
	string wordStem = wn.getNounStem(className); 
	map<string, DomainClass>::iterator iterator;
	iterator = classMap.find(wordStem);
	if (iterator != classMap.end()) {
		DomainClass& returnClass = iterator->second;
		return returnClass;
	} else {
		DomainClass* classPtr = new DomainClass(wordStem);
		DomainClass& returnClass = *classPtr;
		return returnClass;
	}
}
