/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP;

/**
 * Indicates that an implementer can have its dimensions accessed
 * and changed.
 *
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/java/awt/Dimension.html">java.awt.Dimension</a>
 * 
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public interface Sizeable {
	
  /**
   * Set the dimensions of this <code>Sizeable</code>.
   *
   * @param d the user-preferred <code>Dimension</code> of this 
   * <code>Sizeable</code>
   * @see #getDimension() getDimension
   */
  public void setDimension(java.awt.Dimension d);
		
  /**
   * Get the dimensions of this <code>Sizeable</code>.
   *
   * @return the <code>Dimension</code> of this <code>Sizeable</code>
   * @see #setDimension(java.awt.Dimension) setDimension
   */
  public java.awt.Dimension getDimension();

}

