/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP;

/**
 * Indicates that implementing objects will react when 
 * clicked on.  {@link #react() react} should be defined by 
 * implementers to do something useful.
 * 
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/java/awt/event/MouseListener.html">java.awt.event.MouseListener</a>
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/java/awt/event/MouseMotionListener.html">java.awt.event.MouseMotionListener</a>
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public interface Reactor extends java.awt.event.MouseListener, 
				 java.awt.event.MouseMotionListener {
	
  /** 
   * Called when a <code>Reactor</code> decides that it was 
   * clicked on. 
   */
  public void react();

}

