/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP;

/**
 * Indicates that the implementer maintains its location on the screen
 * and provides accessors/mutators.
 *
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/java/awt/Point.html">java.awt.Point</a>
 * 
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public interface Locatable {
	
  /**
   * Set the location of this <code>Locatable</code> to the passed
   * in <code>Point</code>.
   *
   * @param p the new <code>Point</code> for this <code>Locatable</code>
   * @see #getLocation() getLocation
   */
  public void setLocation(java.awt.Point p);
	
  /**
   * Get the location of this <code>Locatable<code>.
   *
   * @return the <code>Point</code> for this <code>Locatable</code>
   * @see #setLocation(java.awt.Point) setLocation
   */
  public java.awt.Point getLocation();

}

