/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP;

/**
 * Indicates that a specific <code>Container</code> has methods to control 
 * horizontal alignment.  However, each implementing Container may do it 
 * somewhat differently.
 * 
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public interface HAligner {

  /** See the specific implementer for details. */
  public void alignLeft();

  /** See the specific implementer for details. */
  public void alignRight();

  /** See the specific implementer for details. */	
  public void alignCenter();
	
}

