/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Graphics;

import java.awt.geom.Line2D;

/**
 * A Line is a Shape composed of two endpoints.  Right now, it doesn't
 * react, or wrap for that matter like Shapes do.  It has some of its
 * own methods that are line specific.
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public class Line extends Shape {

  /** Our endpoints */
  private java.awt.Point _p1, _p2;
  /** Our line thickness */
  private float _thickness;

  /**
   * Create a line with the given DrawingPanel
   *
   * @param dp the DrawingPanel for this Line
   */
  public Line(NGP.Containers.DrawingPanel dp) {
    super(dp, new Line2D.Double());
    _thickness = 1f;
		this.show();
  }

  /**
   * Set the endpoints for this Line.
   *
   * @param p1 the first <code>Point</code>
   * @param p2 the second <code>Point</code>
   */
  public void setPoints(java.awt.Point p1, java.awt.Point p2) {
		java.awt.Rectangle oldBounds = this.getBounds();
    _p1 = p1;
    _p2 = p2;
    ((Line2D)_awtShape).setLine(p1, p2);
    _dpanel.repaint(this.getBounds().union(oldBounds));
  }

  /**
   * Gets the first endpoint
   *
   * @return the first endpoint
   */
  public java.awt.Point getP1() {
    return _p1;
  }

  /**
   * Gets the second endpoint
   *
   * @return the second endpoint
   */
  public java.awt.Point getP2() {
    return _p2;
  }

  /**
   * Set the thickness of the Line
   *
   * @param thickness the float (you might need to cast) representing the
   * thickness
   */
  public void setThickness(float thickness) {
    _thickness = thickness;
    _dpanel.repaint(this.getBounds());
  }

  /**
   * Get the thickness of the Line
   *
   * @return the float representing the thickness of the Line
   */
  public float getThickness() {
    return _thickness;
  }

  /**
   * Normal users need not use this!
   *<p>
   * Play with the stroke and paint the line.
   */
  public void actualPaint(java.awt.Graphics2D g) {
    java.awt.Stroke old = g.getStroke();
    g.setStroke(new java.awt.BasicStroke(_thickness));
    g.draw(_awtShape);
    g.setStroke(old);
  }

  /**
   * Return the bounding rectangle. If the rotation is along an axis grow
   * the rectangle so that it will paint correctly.
   *
   * @return the java.awt.Rectangle that represents the bounds of the line
   */
  public java.awt.Rectangle getBounds() {
    java.awt.Rectangle r = super.getBounds();
    if (this.getRotation() % 90 == 0) {
      r.grow(3,3);
    }
    return r;
  }

  /**
   * Lines cannot react.  I'm not sure why they don't pick up the clicks,
   * but for now, just accept that they don't.
   */
  public final void react() { }

}

