/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Graphics;

/**
 * A framed rounded-edge rectangle.
 *
 * To change the arc height and width do something like:
 * <pre>((java.awt.geom.RoundRectangle2D.Double)_awtShape).archeight = 5.0;
 * ((java.awt.geom.RoundRectangle2D.Double)_awtShape).arcwidth = 5.0;</pre>
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public class FramedRoundRectangle extends FramedRectangularShape {

  /**
   * Create a RoundRectangle with the specified DrawingPanel
   * and an arc height and width of 5.
   *
   * @param dp the DrawingPanel for this RoundRectangle
   */
  public FramedRoundRectangle(NGP.Containers.DrawingPanel dp) {
    super(dp, new java.awt.geom.RoundRectangle2D.Double());
    ((java.awt.geom.RoundRectangle2D.Double)_awtShape).archeight = 5.0;
    ((java.awt.geom.RoundRectangle2D.Double)_awtShape).arcwidth = 5.0;
  }

}

