/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Graphics;

/**
 * All subclasses use an outlined drawing method.
 * The thickness of that outline can be modified.
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */
public abstract class FramedRectangularShape extends RectangularShape {

  /** We can change our border's thickness */
  private float _thickness;

  /** Create the shape with a default outline thickness of 1 */
  public FramedRectangularShape(NGP.Containers.DrawingPanel dp, 
																java.awt.Shape s) {
    super(dp, s);
    _thickness = 1.0f;
		this.show();
  }

  /**
   * Set the thickness of this shape
   *
   * @param thickness the float (you may need to cast) representing the
   * thickness of the border
   */
  public void setThickness(float thickness) {
    _thickness = thickness;
  }

  /**
   * Get the thickness of this shape
   *
   * @return the float representing the thickness of the border
   */
  public float getThickness() {
    return _thickness;
  }

  /**
   * Normal users need not use this!
   * <p>
   * Alter the thickness, draw the shape, reset the thickness.
   */
  public void actualPaint(java.awt.Graphics2D g) {
    java.awt.Stroke old = g.getStroke();
    g.setStroke(new java.awt.BasicStroke(_thickness));
    g.draw(_awtShape);
    g.setStroke(old);
  }

  public java.awt.Rectangle getBounds() {
    java.awt.Rectangle rect = super.getBounds();
    rect.grow(2,2);
    return rect;
  }

}

