/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Graphics;

/**
 * A special subclass of FilledRectangularShape that draws 3D rectangles.
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public class Filled3DRectangle extends FilledRectangularShape {

  /**
   * Create a Filled3DRectangle with the specified DrawingPanel
   *
   * @param dp the DrawingPanel for this Rectangle
   */
  public Filled3DRectangle(NGP.Containers.DrawingPanel dp) {
    super(dp, new java.awt.Rectangle());
  }

  /**
   * Normal users need not use this!
   * <p>
   * This has a special kind of actualPaint since it needs to use
   * the special Graphics method
   */
  public void actualPaint(java.awt.Graphics2D g) {
    java.awt.Point p = this.getLocation();
    java.awt.Dimension d = this.getDimension();
    g.fill3DRect(p.x, p.y, d.width, d.height, true);
  }

}
