/**
 * Window.java
 *
 *
 * Created: Thu Oct 11 10:21:47 2001
 *
 * @author <a href="mailto: "</a>
 * @version
 */

/**
 * A high-level Container that should be used as the first container
 * instantiated in an application.  The frame provides most of the framework
 * for an application, so this is what you can resize freely to provide the
 * look you desire.  Immediately after you instantiate this, you should create
 * a {@link Panel Panel} that will contain everything else, as the Window has
 * very poor layout management.
 *
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/JWindowe.html">javax.swing.JWindow</a>
 *
 * @author Keke Chen (<a href="mailto:kekechen@cc.gatech.edu">email</a>)
 */

package NGP.Containers;


public class Window extends javax.swing.JWindow
   implements NGP.Container, NGP.Locatable{
   public Window (NGP.Containers.Frame f){
      super(f);
   }


  /**
   * Normal users need not use this!
   * <p>
   * Get the content pane as a JFrame does not add directly and add the component.
   *
   * @param c the <code>Component</code> to add
   */
  public java.awt.Component add(java.awt.Component c) {
    return this.getContentPane().add(c);
  }

  /**
   * Remove the component from the container so it will no longer be repainted.
   *
   * @param c the <code>Component</code> to remove
   */
  public void remove(java.awt.Component c) {
    this.getContentPane().remove(c);
  }

  /**
   * Set the color of this <code>Container</code>
   *
   * @param c the <code>Color</code> to use
   */
  public void setColor(java.awt.Color c) {
    this.getContentPane().setBackground(c);
  }

  /**
   * Return the color of this <code>Container</code>
   *
   * @return the <code>Color</code> of this container
   */
  public java.awt.Color getColor() {
    return this.getContentPane().getBackground();
  }

  /**
   * Set the dimensions of this <code>Container</code>
   *
   * @param d the <code>Dimension</code> to use
   */
  public void setDimension(java.awt.Dimension d) {
    this.setSize(d);
  }

  /**
   * Return the dimensions of this <code>Container</code>
   *
   * @return the <code>Dimension</code> of this container
   */
  public java.awt.Dimension getDimension() {
    return this.getPreferredSize();
  }


}// Window
