
/**
 * TabbedPane.java
 *
 *
 * Created: July 16 2002
 *
 * @author <a href="mailto: "</a>
 * @version
 */

package NGP.Containers;

import java.awt.*;

public class TabbedPane extends javax.swing.JTabbedPane
   implements NGP.Container {


   public TabbedPane(NGP.Container container, int tabPlace) {
     super(tabPlace);
     container.add(this);
   }
   
  /**
   * This method allows keyboard focus to be given to the Panel.  You should
   * never need to call this method.
   */      
  public boolean isFocusTraversable() {
    return true;
  }

  /**
   * Set the color of this <code>Container</code>
   *
   * @param c the <code>Color</code> to use
   */
  public void setColor(Color c) {
    this.setBackground(c);
  }

  /**
   * Return the color of this <code>Container</code>
   *
   * @return the <code>Color</code> of this container
   */
  public Color getColor() {
    return this.getBackground();
  }

  /**
   * Set the dimensions of this <code>Container</code>
   *
   * @param d the <code>Dimension</code> to use
   */
  public void setDimension(Dimension d) {
    this.setPreferredSize(d);
    this.setMaximumSize(d);
  }

  /**
   * Return the dimensions of this <code>Container</code>
   *
   * @return the <code>Dimension</code> of this container
   */
  public Dimension getDimension() {
    return this.getPreferredSize();
  }

}// TabbedPane








