/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Containers;

//an import statement means I can refer to a class as if I specified the
//whole package
import java.awt.FlowLayout;
import java.awt.Component;
import java.awt.Panel;
import java.awt.Dimension;
import javax.swing.BoxLayout;

/**
 * A graphical container that will organize objects in a row.
 * This class is a subclass of the Panel but it uses the Swing
 * BoxLayout with a X-AXIS organization as its LayoutManager.  It is not
 * the optimal way of doing things, but it is the best solution currently
 * known.<br>
 * Use it whenever you want to organize any GUI components (or other
 * containers) horizontally.
 *
 * @see NGP.Containers.Column
 * @see NGP.Containers.GridContainer
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public class Row extends NGP.Containers.Panel
  implements NGP.HAligner {

  /** The layout for this container */
  protected BoxLayout _layout;
  /** The layout for the panels we will contain */
  private FlowLayout _panelLayout;
  /** How we will store the panels */
  private java.util.Vector _panels;

  /**
   * Construct a row.  The default alignment is centered, so that all
   * components added to this container will be centered.  Use
   * {@link #alignLeft() alignLeft}, {@link #alignRight() alignRight}, or
   * {@link #alignCenter() alignCenter} to gain control over the alignment
   * of the row.
   *
   * @param container the graphical container for this row
   */
  public Row(NGP.Container container) {
    super(container);
    _layout = new BoxLayout(this, BoxLayout.X_AXIS);
    this.setLayout(_layout);
    _panelLayout = new FlowLayout(FlowLayout.CENTER);
    _panels = new java.util.Vector();
  }

  /**
   * Normal users need not use this!
   * <p>																
   * Add a component to this container.  This will create a panel for each
   * component that is added to the container (to make sure that the sizing
   * of each contained component is optimal).
   *
   * @param comp the component to be added
   * @return returns a Component; you generally do not need to do anything with
   * this
   */
  public Component add(Component comp) {
    NGP.Containers.Panel panel = new NGP.Containers.Panel();
    panel.setLayout(_panelLayout);
    panel.setColor(this.getColor());
    _panels.addElement(panel);
    panel.add(comp);
    return super.add(panel);
    /*Panel panel = new Panel(_panelLayout);
    _panels.addElement(panel);
    panel.add(comp);
    return super.add(panel);*/
  }

  /**
   * Remove the component from the container and resize the container.
   * @param comp the component to remove
   */
  public void remove(Component comp) {
    NGP.Containers.Panel panel = null;

    //go through the vector of panels and get the one that contains the
    //component we want to remove

    for (int i = 0; i < _panels.size(); i++) {
      panel = (NGP.Containers.Panel)_panels.get(i);
      if (comp == panel.getComponent(0)) break;
      panel = null;
    }

    //make sure we found the panel, then remove the component and resize
    //the column

    if (panel != null) {
      panel.remove(comp);
      _panels.removeElement(panel);
      super.remove(panel);
      this.setSize(this.getPreferredSize());
    }
  }

  /**
   * Set the color of this <code>Container</code>
   *
   * @param c the <code>Color</code> to use
   */
  public void setColor(java.awt.Color c) {
    super.setColor(c);
    for (int i = 0; i < _panels.size(); i++) {
      ((NGP.Containers.Panel)_panels.get(i)).setColor(c);
    }
  }
  
  /**
   * Align all components added after this is called to the left.
   * Will not affect any components added previously to this call.
   */
  public void alignLeft() {
    _panelLayout = new FlowLayout(FlowLayout.LEFT);
  }

  /**
   * Align all components added after this is called to the right.
   * Will not affect any components added previously to this call.
   */
  public void alignRight() {
    _panelLayout = new FlowLayout(FlowLayout.RIGHT);
  }

  /**
   * Align all components added after this is called in the center.
   * Will not affect any components added previously to this call.
   */
  public void alignCenter() {
    _panelLayout = new FlowLayout(FlowLayout.CENTER);
  }

}
