/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Containers;

//an import statement means I can refer to a class as if I specified the
//whole package
import javax.swing.*;
import java.awt.*;

/**
 * The main Container class.  The Layout is the standard AWT FlowLayout
 * which means that components will fill in left-to-right and then down
 * as necessary.  Use the Row and Column subclasses for creating GUIs,
 * but this is ok as your base panel.
 *
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/JPanel.html">javax.swing.JPanel</a>
 *
 * @author Matt Chotin (<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public class Panel extends JPanel implements NGP.Container {

  /**
   * Create a panel that will use the specified container as its parent.
   *
   * @param container the graphical container that this container will reside
   * in
   */
  public Panel(NGP.Container container) {
    super();
    container.add(this);
  }

  /**
   * This constructor creates a Panel but does not add it to any parent
   * container.  This should only be used by the Row and Column subclasses.
   */
  Panel() {
    super();
  }

  /**
   * This method allows keyboard focus to be given to the Panel.  You should
   * never need to call this method.
   */      
  public boolean isFocusTraversable() {
    return true;
  }

  /**
   * Set the color of this <code>Container</code>
   *
   * @param c the <code>Color</code> to use
   */
  public void setColor(Color c) {
    this.setBackground(c);
  }

  /**
   * Return the color of this <code>Container</code>
   *
   * @return the <code>Color</code> of this container
   */
  public Color getColor() {
    return this.getBackground();
  }

  /**
   * Set the dimensions of this <code>Container</code>
   *
   * @param d the <code>Dimension</code> to use
   */
  public void setDimension(Dimension d) {
    this.setPreferredSize(d);
    this.setMaximumSize(d);
  }

  /**
   * Return the dimensions of this <code>Container</code>
   *
   * @return the <code>Dimension</code> of this container
   */
  public Dimension getDimension() {
    return this.getPreferredSize();
  }

}

