/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Components;

import javax.swing.JTextArea;

/**
 * A text area for multiple lines (unlike a TextBox which can only do
 * one line.  It is a subclass of the Swing JTextArea.
 * <p>
 * Special methods you may want: setLineWrap, setWrapStyleWord, setEditable,
 * setBackground (to set background color of field), setForeground (to set
 * text color), and finally setText.  Look in the inherited methods for these.
 */
public class TextArea extends JTextArea implements NGP.Component {

  /**
   * Construct a TextArea with all defaults.
   *
   * @param container the graphical container for the text area
   */
  public TextArea(NGP.Container container) {
    super();
    container.add(this);
  }

  /**
   * Construct a TextArea of specified number of rows and columns.
   *
   * @param container the graphical container for the text area
   * @param rows how many rows the area should display at once
   * @param columns how many columns the area should display
   */
  public TextArea(NGP.Container container, int rows, int columns) {
    super(rows, columns);
    container.add(this);
  }

  /**
   * Construct a TextArea of specified number of rows and columns and
   * default text.
   *
   * @param container the graphical container for the text area
   * @param text a String containing the text to display by default
   * @param rows how many rows the area should display at once
   * @param columns how many columns the area should display
   */
  public TextArea(NGP.Container container, String text, int rows,
		  int columns) {
    super(text, rows, columns);
    container.add(this);
  }
    
  /**
   * Set the preferred dimensions of this Component.
   *
   * @param d the <code>Dimension</code> for this <code>Component</code>.
   * @see #getDimension() getDimension
   */
  public void setDimension(java.awt.Dimension d) {
    this.setPreferredSize(d);
  }

  /**
   * Get the preferred dimensions of this Component.
   *
   * @return the preferred <code>Dimension</code> of this
   * <code>Component</code>.
   * @see #setDimension(java.awt.Dimension) setDimension
   */
  public java.awt.Dimension getDimension() {
    return this.getPreferredSize();
  }

}
