
/**
 * ScrollPane.java
 *
 *
 * Created: Sat Oct 13 20:45:01 2001
 *
 * @author <a href="mailto: "</a>
 * @version
 */

package NGP.Containers;

import java.awt.*;

public class ScrollPane extends javax.swing.JScrollPane
   implements NGP.Container {


   public ScrollPane(NGP.Container container, Component c) {
     super(c);
     container.add(this);
   }

   public ScrollPane(NGP.Container container) {
     container.add(this);
   }
   
  /**
   * This method allows keyboard focus to be given to the Panel.  You should
   * never need to call this method.
   */      
  public boolean isFocusTraversable() {
    return true;
  }

  /**
   * Set the color of this <code>Container</code>
   *
   * @param c the <code>Color</code> to use
   */
  public void setColor(Color c) {
    this.setBackground(c);
  }

  /**
   * Return the color of this <code>Container</code>
   *
   * @return the <code>Color</code> of this container
   */
  public Color getColor() {
    return this.getBackground();
  }

  /**
   * Set the dimensions of this <code>Container</code>
   *
   * @param d the <code>Dimension</code> to use
   */
  public void setDimension(Dimension d) {
    this.setPreferredSize(d);
    this.setMaximumSize(d);
  }

  /**
   * Return the dimensions of this <code>Container</code>
   *
   * @return the <code>Dimension</code> of this container
   */
  public Dimension getDimension() {
    return this.getPreferredSize();
  }

}// ScrollPane








