/*
 * Copyright 1999 by Brown University Computer Science
 * 115 Waterman Street, 4th Floor, Providence, Rhode Island, 02906, U.S.A
 * All rights reserved.
 *
 * Permission is hereby granted for free use and modification of this
 * software.  However, this copyright must remain at all times.
 * Re-distribution is restricted to those with the express written consent
 * of the copyright holder.  Permission can be obtained by mailing
 * cs015headtas@cs.brown.edu.  
 */

package NGP.Components;

//an import statement means I can refer to a class as if I specified the
//whole package
import javax.swing.JRadioButton;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

/**
 * A simple radio button.  This class models a simple radio button and is a
 * subclass of the Swing JRadioButton component.  Use it when you want to
 * select individual options that are exclusive of each other.  This means
 * that you'll generally want to use this in conjunction with a RadioColumn
 * or RadioRow.
 *
 * @see NGP.Components.CheckBox
 * @see NGP.Components.ToggleButton
 * @see NGP.Components.PushButton
 * @see NGP.Containers.RadioColumn
 * @see NGP.Containers.RadioRow
 * @see <a href="http://java.sun.com/products/jdk/1.2/docs/api/javax/swing/JRadioButton.html">javax.swing.JRadioButton</a>
 *
 * @author Matt Chotin(<a href="mailto:mhc@cs.brown.edu">mhc</a>)
 */

public class RadioButton extends JRadioButton implements NGP.Component {

  /**
   * Construct an unselected radio button.
   *
   * @param container the graphical container for the radio button
   * @param name the string that will be displayed next to the button
   */
  public RadioButton(NGP.Container container, String name) {
    this(container, name, false);
  }

  /**
   * Construct a radio button and leave it selected or unselected according to
   * the boolean.
   *
   * @param container the graphical container for the radio button
   * @param name the string that will be displayed next to the button
   * @param selected Use <code>true</code> to select the button and
   * <code>false</code> to leave it unselected.
   */
  public RadioButton(NGP.Container container, String name,
		     boolean selected) {
    super(name, selected);

    this.addItemListener(new RadioButtonListener());

    container.add(this);
  }

  /**
   * Set the preferred dimensions of this Component.
   *
   * @param d the <code>Dimension</code> for this <code>Component</code>.
   * @see #getDimension() getDimension
   */
  public void setDimension(java.awt.Dimension d) {
    this.setPreferredSize(d);
  }

  /**
   * Get the preferred dimensions of this Component.
   *
   * @return the preferred <code>Dimension</code> of this
   * <code>Component</code>.
   * @see #setDimension(java.awt.Dimension) setDimension
   */
  public java.awt.Dimension getDimension() {
    return this.getPreferredSize();
  }

  /**
   * Disable the Spacebar from activating this component.
   */
  public void disableSpace() {
    this.unregisterKeyboardAction(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_SPACE, 0));
  }
  
  /**
   * Called when the button is selected.
   * Must override to do something useful.
   */
  public void select() { }

  /**
   * Called when the button is deselected.
   * Must override to do something useful (though not overriding means
   * that nothing will happen when deselected which is often ok).
   */
  public void deselect() { }


  /**
   * This inner-class is a listener for the radio button.  It will detect when
   * the button is selected/deselected and call the appropriate method of
   * the radio button.
   */
  private class RadioButtonListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      if (e.getStateChange() == ItemEvent.SELECTED)
	select();
      else if (e.getStateChange() == ItemEvent.DESELECTED)
	deselect();
    }
  }
}
